% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mappers.R
\name{format.bru_mapper}
\alias{format.bru_mapper}
\alias{format.bm_list}
\alias{summary.bru_mapper}
\alias{format.bm_multi}
\alias{format.bm_pipe}
\alias{format.bm_collect}
\alias{format.bm_sum}
\alias{format.bm_repeat}
\alias{print.summary_bru_mapper}
\alias{print.bru_mapper}
\alias{print.bm_list}
\title{mapper object summaries}
\usage{
\method{format}{bru_mapper}(x, ..., prefix = "", initial = prefix, depth = 1)

\method{format}{bm_list}(
  x,
  ...,
  prefix = "",
  initial = prefix,
  depth = 1,
  collapse = ", ",
  labels = TRUE
)

\method{summary}{bru_mapper}(object, ..., prefix = "", initial = prefix, depth = 1)

\method{format}{bm_multi}(x, ..., prefix = "", initial = prefix, depth = 1)

\method{format}{bm_pipe}(x, ..., prefix = "", initial = prefix, depth = 1)

\method{format}{bm_collect}(x, ..., prefix = "", initial = prefix, depth = 1)

\method{format}{bm_sum}(x, ..., prefix = "", initial = prefix, depth = 1)

\method{format}{bm_repeat}(x, ..., prefix = "", initial = prefix, depth = 1)

\method{print}{summary_bru_mapper}(x, ..., sep = "\\n")

\method{print}{bru_mapper}(x, ..., sep = "\\n", prefix = "", initial = prefix, depth = 1)

\method{print}{bm_list}(
  x,
  ...,
  sep = "\\n",
  prefix = "",
  initial = prefix,
  depth = 1,
  labels = TRUE,
  collapse = ", "
)
}
\arguments{
\item{x}{Object to format/print}

\item{\dots}{Unused arguments}

\item{prefix}{character prefix for each line. Default \code{""}.}

\item{initial}{character prefix for the first line. Default \code{initial=prefix}.}

\item{depth}{The recursion depth for multi/collection/pipe mappers. Default
1, to only show the collection, and not the contents of the sub-mappers.}

\item{collapse}{character or NULL, as in \code{\link[base:paste]{base::paste()}}.}

\item{labels}{logical; if TRUE, include mapper names or numerical indices.
Default \code{TRUE}}

\item{object}{Object to summarise}

\item{sep}{character; separator for printing the summary.}
}
\description{
mapper object summaries
}
\examples{
mapper <-
  bm_pipe(
    list(
      bm_multi(list(
        A = bm_index(2),
        B = bm_index(3)
      )),
      bm_index(2)
    )
  )
summary(mapper, depth = 2)
mapper <-
  bm_repeat(
    bm_multi(
      list(
        A = bm_index(2),
        B = bm_index(3)
      )
    ),
    3
  )
summary(mapper)
summary(mapper, depth = 0)
}
