% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mappers.R
\name{bm_index}
\alias{bm_index}
\alias{bru_mapper_index}
\alias{ibm_invalid_output.bm_index}
\alias{ibm_jacobian.bm_index}
\title{Mapper for indexed variables}
\usage{
bm_index(n = 1L, ...)

bru_mapper_index(...)

\method{ibm_invalid_output}{bm_index}(mapper, input, state, ...)

\method{ibm_jacobian}{bm_index}(mapper, input, state, ...)
}
\arguments{
\item{n}{Size of a model for \code{bm_index}}

\item{...}{Arguments passed on to other methods}

\item{mapper}{A mapper S3 object, inheriting from \code{bru_mapper}.}

\item{input}{Data input for the mapper.}

\item{state}{A vector of latent state values for the mapping,
of length \code{ibm_n(mapper, inla_f = FALSE)}}
}
\description{
Create a an indexing mapper
}
\examples{
m <- bm_index(4)
ibm_eval(m, -2:6, 1:4)
}
\seealso{
\link{bru_mapper}, \link{bru_mapper_generics}

Other mappers: 
\code{\link{bm_aggregate}()},
\code{\link{bm_collect}()},
\code{\link{bm_const}()},
\code{\link{bm_factor}()},
\code{\link{bm_fmesher}()},
\code{\link{bm_harmonics}()},
\code{\link{bm_linear}()},
\code{\link{bm_logsumexp}()},
\code{\link{bm_marginal}()},
\code{\link{bm_matrix}()},
\code{\link{bm_mesh_B}()},
\code{\link{bm_multi}()},
\code{\link{bm_pipe}()},
\code{\link{bm_repeat}()},
\code{\link{bm_scale}()},
\code{\link{bm_shift}()},
\code{\link{bm_sum}()},
\code{\link{bm_taylor}()},
\code{\link{bru_get_mapper}()},
\code{\link{bru_mapper}()},
\code{\link{bru_mapper.fm_mesh_1d}()},
\code{\link{bru_mapper.fm_mesh_2d}()},
\code{\link{bru_mapper_generics}}
}
\concept{mappers}
