% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/injector.R
\name{define}
\alias{define}
\title{Creates a key to factory binding}
\usage{
define(..., scope = default, binder = .binder)
}
\arguments{
\item{...}{injectable bean identifier to factory mappings, the key
is the name is matched to a parameter name during injection, the
factory responsible for provisioning of the bean, a factory may
accept any number of arguments in which case the framework will
attempt to inject the argument if a binding to the parameter name
exists; if it does not, that argument will not be injected, in
which case it is the factory's responsibility to deal with a
missing argument}

\item{scope}{of the bean, wraps the injected factory call
specifying provisioning strategy, if omitted a new bean instance
will be provisioned each time injection is requested; injectoR also
ships with with the singleton scope which will provide once and
cache the bean for subsequent calls. Interface allows for custom
scoping, the scope parameter must be a function accepting key (name)
and the provider - the wrapped injected factory call - a function
accepting no parameters responsible for actual provisioning}

\item{binder}{for this binding, if omitted the new binding is added
to the root binder}
}
\description{
Creates a key to factory binding
}
\examples{
define (hello = function () 'world', binder = binder ())
}

