% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/paste.R
\name{\%+\%}
\alias{\%+\%}
\title{Paste Infix Operator}
\usage{
lhs \%+\% rhs
}
\arguments{
\item{lhs}{The left-hand side.}

\item{rhs}{The right-hand side.}
}
\value{
A string pasting the rhs to the lhs.
}
\description{
Many programming languages utilize \code{+} as a means of
concatenating strings. In standard R, however, \code{+} will
return an error when used with strings. \verb{\%+\%} provides
this ability for parsimonious string concatenation.
}
\details{
By default, it uses \code{paste0} under the
hood, but this can be shifted to \code{paste} by running
\code{options(infixit.paste = "paste0")}. By default (as with
\code{paste}), this will have the seperator be a single space
(\code{" "}) between the pasted objects. This behavior can be
changed with the \code{infixit.paste_sep} option. E.g.,
\code{options(infixit.paste_sep = "|")}
}
\examples{
{

b <- "An additional sentence."

"This is a sentence. " \%+\% b
}
}
