\name{inequalityCurves}
\alias{inequalityCurves}
\alias{inequalityCurves.decomposition}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{Inequality curves evaluation}
\description{
  Generates step-functions (see \code{\link{stepfun}}) representing inequality curves or sources/subpopulations point contributions in the decomposition \code{x} generated by functions \code{\link{gini}}, \code{\link{bonferroni}} or \code{\link{zenga}}.
}
\usage{
inequalityCurves(x, ...)
\method{inequalityCurves}{decomposition}(x, l = 1:dim(x$decomposition)[2], k = 1:dim(x$decomposition)[4], ...)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{x}{
An object of class \code{decomposition} output of functions \code{\link{gini}}, \code{\link{bonferroni}}, \code{\link{zenga}}.
}

\item{l}{
Vector of selected subpopulations. If only one subpopulation is selected the resulting step function provides its point contributions. More than one subpopulation can be selected and contributions are cumulated. If empty all subpopulations are considered and contributions are marginalized by subpopulations.
}

\item{k}{
Vector of selected sources. If only one source is selected the resulting step function provides its point contributions. More than one source can be selected and contributions are cumulated. If empty all sources are considered and contributions are marginalized by sources.
}
\item{\dots}{
Potentially further arguments (required by the generic).
}
}

\details{
By default generates step functions representing inequality curves of the whole population. If arguments \code{l} and/or \code{k} are defined, resuts are step functions representing point contributions of the selected subpopulations and/or sources.

The class of the result is \code{"inequality_curves"} that is associated to the method \code{\link{plot.inequality_curves}} for graphical representations. Such derived class hinerits the features of the \code{"\link{stepfun}"} class.
}
\value{
An object of class \code{"inequality_curves"} hineriting the features of class \code{"\link{stepfun}"} with the following additional attributes:
\item{index}{String denoting computed index.}
\item{min, max}{The range of values assumed by the function.}
\item{groups}{Vector of names of the subpopulations partitioning the whole population .}
\item{sources}{Vector of names of the all the sources that sum to the total variable \eqn{Y}.}
\item{selected_groups}{Vector of names of the selected subpopulations to evaluate the point contributions.}
\item{selected_sources}{Vector of names of the selected sources to evaluate the point contributions.}
}
\references{
Zenga M. M.(2007). Inequality Curve and Inequality Index based on the Ratios between llower and upper Means . Statistica and Applicazioni, V (1), 3-27.

Zenga M. (2015) Joint decomposition by subpopulations and sources of the point and synthetic Zenga(2007) Index I(Y). Statistica and Applicazioni, XIII (2), pp.163-195.

Zenga M., Valli I. (2017). Joint decomposition by Subpopulations and Sources of the Point and Synthetic Bonferroni Inequality Measures. Statistics and Applications, XV (2), pp. 83-120.

Zenga M., Valli I. (2018). Joint decomposition by Subpopulations and Sources of the Point and Synthetic Gini Indexes. Statistics and Applications, XVI (1).
}
\author{
Alberto Arcagni, Igor Valli
}

%% ~Make other sections like Warning with \section{Warning }{....} ~

\seealso{
See \code{\link{gini}}, \code{\link{bonferroni}}, \code{\link{zenga}} to obtain objects of class \code{decomposition} and see \code{\link{plot.inequality_curves}} for the graphical representation.
}
\examples{
G <- c(1, 2, 3, 1, 2, 3, 1, 1, 2, 3, 3, 3) # vector denoting group membership
X1 <- c(0, 0, 0, 500, 700, 300, 750, 1000, 500, 500, 500, 1000) # vector of the first source
X2 <- c(0, 0, 0, 500, 300, 700, 750, 500, 700, 700, 1000,600) # vector of the second source
data <- data.frame(G, X1, X2) # no sample weights are considered
x <- dataProcessing( # data preparation
  units = data[, c('X1', 'X2')],
  groups = data[, 'G'],
)
decomposition <- zenga(x)

ic <- inequalityCurves(decomposition)
ic
contrib1 <- inequalityCurves(decomposition, l = 1)
contrib1
contrib12 <- inequalityCurves(decomposition, l = 1:2)
contrib12
}