% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metadata_tables.R
\name{get_metadata_table_varval}
\alias{get_metadata_table_varval}
\title{Get metadata information about the variables and values for a given table}
\usage{
get_metadata_table_varval(
  idTable = NULL,
  det = 0,
  filter = NULL,
  lang = "ES",
  validate = TRUE,
  verbose = FALSE
)
}
\arguments{
\item{idTable}{(int): id of the table. For further information about
ids click this \href{https://es-ine.github.io/ineapir/articles/identify_codes.html}{link}.}

\item{det}{(int): level of detail. Valid values: 0, 1 or 2.}

\item{filter}{(list): list of variables and values.
\subsection{Filtering data from tables}{

When we request data from tables there is the possibility of filtering data
on the fly using metadata information about the variables and their values
that define the series. There are different approaches to build the filter depending on the table type.
\subsection{Case one: tempus table}{

\href{https://www.ine.es/jaxiT3/Tabla.htm?t=50902}{URL example}.
For a tempus table the filter is based on ids. The format is \code{list(id_variable1 = id_value1, id_variable2 = id_value2)}.
Besides:
\itemize{
\item A variable can take more than one value: \code{list(id_variable1 = c(id_value11, id_value12), id_variable2 = id_value2)}.
\item A variable can take a empty character "" to get all its possible values: \code{list(id_variable1 = id_value1, id_variable2 = "")}.
}
}

\subsection{Case two: px tables}{

\href{https://www.ine.es/jaxi/Tabla.htm?path=/t20/e245/p08/l0/&file=01001.px}{URL example}.
For a px table the filter is based on codes. The format is \code{list(cod_variable1 = cod_value1, cod_variable2 = cod_value2)}.
Besides:
\itemize{
\item A variable can take more than one value: \code{list(cod_variable1 = c(cod_value11, cod_value12), id_variable2 = cod_value2)}.
\item A variable can take a empty character "" to get all its possible values: \code{list(cod_variable1 = cod_value1, cod_variable2 = "")}.
}
}

\subsection{Case three: tpx table}{

\href{https://www.ine.es/jaxi/Tabla.htm?tpx=33387&L=0}{URL example}.
For a tpx table the filter is based on codes. The format is \code{list(cod_variable1 = cod_value1, cod_variable2 = cod_value2)}.
Besides:
\itemize{
\item A variable can take more than one value: \code{list(cod_variable1 = c(cod_value11, cod_value12), id_variable2 = cod_value2)}.
\item A variable can take a empty character "" to get all its possible values: \code{list(cod_variable1 = cod_value1, cod_variable2 = "")}.
}

\href{https://www.ine.es/jaxi/Tabla.htm?tpx=52056&L=0}{URL example}.
There are tpx tables that contain variable ids and value ids. In this case,
we can use the ids instead of the codes to build the filter. To do this we add
the alias \emph{~id} at the end of each id: \verb{list(id_variable1~id = id_value1~id, id_variable2~id = id_value2~id)}.
}

}}

\item{lang}{(string): language of the retrieved data. Set to 'ES' for Spanish or set to 'EN' for English.}

\item{validate}{(logical): validate input parameters.A FALSE value means fewer API calls.
Therefore, it is recommended to set it to FALSE when there is no doubt about the validity of the input parameters, including the filter.}

\item{verbose}{(logical): print additional information, including the URL to call the API service.}
}
\value{
Data frame with information about the variables and values that define a table according to the table specified in the function
}
\description{
Get metadata information about the variables and values for a given table
}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# Get all the variable and values of the table with identification code "50902"
df <- get_metadata_table_varval(idTable = 50902)
head(df)

# Filter variables and values
df <- get_metadata_table_varval(idTable = 52056,
filter = list(NAC = "00"), validate = FALSE)
head(df)
\dontshow{\}) # examplesIf}
}
