% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metadata_series.R
\name{get_metadata_series_operation}
\alias{get_metadata_series_operation}
\title{Get all the series for a specific operation}
\usage{
get_metadata_series_operation(
  operation = NULL,
  det = 0,
  tip = NULL,
  lang = "ES",
  page = 1,
  validate = TRUE,
  verbose = FALSE
)
}
\arguments{
\item{operation}{(string): code of the operation. To obtain a list of
available operations see \code{\link[=get_metadata_operations]{get_metadata_operations()}}.}

\item{det}{(int): level of detail. Valid values: 0, 1 or 2.}

\item{tip}{(string): set to 'A' for friendly output (e.g. readable dates),
set to 'M' to include metadata or set to 'AM' for both.}

\item{lang}{(string): language of the retrieved data. Set to 'ES' for Spanish or set to 'EN' for English.}

\item{page}{(int): page number. The retrieved result of the query is paginated. Default value is set to 1.}

\item{validate}{(logical): validate input parameters. A FALSE value means fewer API calls.}

\item{verbose}{(logical): print additional information, including the URL to call the API service.}
}
\value{
Data frame with information of the series belonging to an operation.
}
\description{
Get all the series for a specific operation
}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# Get metadata of time series from "IPC" operation
# Retrieve page 1
df <- get_metadata_series_operation(operation = "IPC", validate = FALSE)
nrow(df)

# Retrieve page 2
df <- get_metadata_series_operation(operation = "IPC", validate = FALSE,
page = 2)
nrow(df)
\dontshow{\}) # examplesIf}
}
