% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ss.rr.plots.R
\name{ss.rr.plots}
\alias{ss.rr.plots}
\title{Gage R & R plots}
\usage{
ss.rr.plots(
  var,
  part,
  appr,
  lsl = NA,
  usl = NA,
  sigma = 6,
  data,
  main = "Six Sigma Gage R&R Study",
  sub = "",
  alphaLim = 0.05,
  errorTerm = "interaction",
  digits = 4
)
}
\arguments{
\item{var}{Measured variable}

\item{part}{Factor for parts}

\item{appr}{Factor for appraisers (operators, machines, ...)}

\item{lsl}{Numeric value of lower specification limit used with USL to calculate Study Variation as \%Tolerance}

\item{usl}{Numeric value of upper specification limit used with LSL to calculate Study Variation as \%Tolerance}

\item{sigma}{Numeric value for number of std deviations to use in calculating Study Variation}

\item{data}{Data frame containing the variables}

\item{main}{Main title for the graphic output}

\item{sub}{Subtitle for the graphic output (recommended the name of the project)}

\item{alphaLim}{Limit to take into account interaction}

\item{errorTerm}{Which term of the model should be used as error term (for the model with interation)}

\item{digits}{Number of decimal digits for output}
}
\value{
Generates a list output that can be assigned to a 
user created variable. The plots can then be accessed with the syntax
variable$plot1 to plot6.
}
\description{
Extracts stand alone plots from the ss.rr function of the SixSigma package.
}
\details{
This is a modified version of the function \code{\link[SixSigma]{ss.rr}}  
from the SixSigma package that allows to extract the individual plots from 
the output report. The input arguments of the function are the same
as the original function. See the original function help with ?ss.rr for 
full documentation.
}
\references{
For an example application refer to \url{https://j-ramalho.github.io/industRial/}
}
