% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_objects.R
\name{read_objects}
\alias{read_objects}
\title{Read Objects Based on Parameter List}
\usage{
read_objects(
  folders,
  parameters_list,
  hash_includes_timestamp = FALSE,
  ignore_script_name = FALSE,
  ignore_na = TRUE,
  alphabetical_order = TRUE,
  algo = "xxhash64",
  print_hash = FALSE,
  tagging_file_name = "indexr_tagging.txt",
  silent = FALSE
)
}
\arguments{
\item{folders}{Character vector specifying the paths to directories containing the saved objects. The function will check each folder in order to find the file.}

\item{parameters_list}{A named list of arguments used to generate a unique hash for the file.}

\item{hash_includes_timestamp}{Logical. If \code{TRUE}, the timestamp is included in the hash generation.}

\item{ignore_script_name}{Logical. If \code{TRUE}, the script name is ignored during hash generation.}

\item{ignore_na}{Logical. If \code{TRUE}, \code{NA} values in \code{parameters_list} are ignored during hash generation.}

\item{alphabetical_order}{Logical. If \code{TRUE}, the names in \code{parameters_list} are sorted alphabetically before hash generation.}

\item{algo}{Character string specifying the hashing algorithm to use. Default is \code{"xxhash64"}.}

\item{print_hash}{Logical. If \code{TRUE}, prints the generated hash. This is helpful for debugging.}

\item{tagging_file_name}{Character string of a txt file that is being used for tagging results. See \code{?start_tagging}.}

\item{silent}{Logical. If \code{TRUE}, no check is done that pairs of results files (parameters and associated results) is done. This check is not necessary, but done by default to keep the user aware of a scenario that usually results from manual file manipulation.}
}
\value{
The data stored in the file retrieved, typically the results. Returns \code{NULL} if the file is not found in any of the specified folders.
}
\description{
Reads R objects from specified folders based on a generated hash of the provided \code{parameters_list}.
}
\details{
This function attempts to read an R object from files located in one of the specified folders. The file name is based on the hash of the provided arguments. If the object is successfully read and a tagging files exists and is specified, the function appends the hash and the current timestamp to the tagging file in the folder where the file was found.
}
\examples{
## Setup
tmp_dir <- file.path(tempdir(), "example")
dir.create(tmp_dir)

## Example using parameter list to run simulation and save results
parameters_list <- list(
  iterations = 1000,
  x_dist = "rnorm",
  x_dist_options = list(n = 10, mean = 1, sd = 2),
  error_dist = "rnorm",
  error_dist_options = list(n = 10, mean = 0, sd = 1),
  beta0 = 1,
  beta1 = 1
)

betas <- numeric(parameters_list$iterations)
for (i in 1:parameters_list$iterations) {
  x <- do.call(parameters_list$x_dist, parameters_list$x_dist_options)
  err <- do.call(parameters_list$error_dist, parameters_list$error_dist_options)
  y <- parameters_list$beta0 + parameters_list$beta1*x + err
  betas[i] <- coef(lm(y ~ x))["x"]
}

save_objects(folder = tmp_dir, results = betas, parameters_list = parameters_list)

## Read back in (consider clearing environment before running)
## Re-setup
tmp_dir <- file.path(tempdir(), "example")

parameters_list <- list(
  iterations = 1000,
  x_dist = "rnorm",
  x_dist_options = list(n = 10, mean = 1, sd = 2),
  error_dist = "rnorm",
  error_dist_options = list(n = 10, mean = 0, sd = 1),
  beta0 = 1,
  beta1 = 1
)

betas <- read_objects(folder = tmp_dir, parameters_list = parameters_list)

## Cleanup
unlink(tmp_dir, recursive = TRUE)

}
\seealso{
\code{\link[=save_objects]{save_objects()}}
}
