% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cleanup_from_hash_table.R
\name{cleanup_from_hash_table}
\alias{cleanup_from_hash_table}
\title{Remove Files Based on Hash Table}
\usage{
cleanup_from_hash_table(
  folder,
  hash_table,
  mode = c("manual", "all"),
  column = NULL,
  request_confirmation = TRUE
)
}
\arguments{
\item{folder}{A string specifying the directory containing the RDS files.}

\item{hash_table}{A \code{data.frame} from \code{create_hash_table}.}

\item{mode}{A character string. When \code{mode = "manual"} (default) the function expects that the user will add a column to a hash table that indicated which files to delete. When \code{mode = "all"}, any results in the hash table will be removed.}

\item{column}{A character string indicating the logical column in \code{hash_table} specifying which files to delete.}

\item{request_confirmation}{Logical, if TRUE will request user input before proceeding to delete files.}
}
\value{
Nothing, this function is called for its side effects.
}
\description{
Allows the user to leverage the \code{generate_hash} function to generate a table that is subsequently used to remove indicated results.
}
\details{
There are a few ways to use this. When \code{mode = "manual"} (default) the function expects that the user will add a column to a hash table that indicated which files to delete. When \code{mode = "all"}, any results in the hash table will be removed. This is generally only used when a \code{filter_list} is passed to \code{create_hash_table}.
}
\examples{
## Setup
tmp_dir <- file.path(tempdir(), "example")
dir.create(tmp_dir)

## Save example objects
parameters_list1 <- list(example = "tagging1")
parameters_list2 <- list(example = "tagging2")
save_objects(folder = tmp_dir, results = 1, parameters_list = parameters_list1)
save_objects(folder = tmp_dir, results = 2, parameters_list = parameters_list2)

## See the files saved
list.files(tmp_dir)

## Create hash table (flat file of result parameters)
hash_table <- create_hash_table(folder = tmp_dir)

## Delete "all" files based on hash table, without confirmation
cleanup_from_hash_table(
  folder = tmp_dir, hash_table = hash_table, mode = "all", request_confirmation = FALSE
)

## See the files have been deleted
list.files(tmp_dir)

## Cleanup
unlink(tmp_dir, recursive = TRUE)
}
\seealso{
\code{\link[=create_hash_table]{create_hash_table()}}
}
