#ifndef REHUBER_HPP
#define REHUBER_HPP

#include <RcppArmadillo.h>

namespace rehuber {

    using namespace arma;

    double pen(const colvec& adjwt, const colvec& wt) {
        size_t i;
        colvec df = abs(wt / adjwt - 1.0);
        for (i = 0; i < df.size(); i++) {
            if (df[i] < 1.0) df[i] *= df[i];
        }
        return sum(df);
    }

    colvec penGrd(const colvec& adjwt, const colvec& wt) {
        size_t i;
        colvec df = wt / adjwt;
        colvec dg = df / adjwt;
        colvec dv = abs(df - 1.0);
        for (i = 0; i < dv.size(); i++) {
            if (dv[i] < 1.0) {
                dv[i] *= 2.0;
            }
            else {
                dv[i] = 1.0;
            }
        }
        return dv % dg % sign(1.0 - df);
    }

}

#endif // REHUBER_HPP
