% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/randomizer.R
\name{.randomize_internal}
\alias{.randomize_internal}
\title{Add a Random Treatment Indicator Column to a Data Frame}
\usage{
.randomize_internal(data, group_by = NULL, seed = NULL, pr_treated = 0.5)
}
\arguments{
\item{data}{The input data frame.}

\item{group_by}{(Optional) A character vector of column names to stratify the
randomization. If provided, the randomization will be done within
d each groupefined by the specified columns.}

\item{seed}{(Optional) An integer to set the random seed for reproducibility.}

\item{pr_treated}{(Optional) The probability of a row being assigned to the
treatment group (TRUE). Default is 0.5.}
}
\value{
A new data frame with the added "treated" column.
}
\description{
This function takes a data frame and adds a new column named "treated" with
randomly assigned TRUE/FALSE values. Randomization can be done either on
the entire data frame or stratified by specified columns. The probability of
being assigned to the treatment group can be specified, with a
default of 0.5.
}
