% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Element_norm.R
\name{Element_norm}
\alias{Element_norm}
\title{Calculate normalized values for a list of elements}
\usage{
Element_norm(
  data,
  return = "rect",
  chondrite = PalmeOneill2014CI,
  prefix = NULL,
  suffix = NULL,
  Element_list = REE_plus_Y_Elements
)
}
\arguments{
\item{data}{a data frame}

\item{return}{a character from: "rect" for a wide data return,"raw" for a long data return,"append" to append the results to the input data}

\item{chondrite}{an option from: PalmeOneill2014CI, Oneill2014Mantle, McDonough1995CI}

\item{prefix}{A prefix in your columns e.g. ICP_La}

\item{suffix}{A suffix in your columns e.g. La_ppm}

\item{Element_list}{a character vector: indicating the elements that should be normalized. REE + Y by default}
}
\value{
a data frame
}
\description{
Element norm normalize values according to published values for the Primitive mantle and chondrites. By defect, it uses the values from Palme and O'Neill (2014). By default, REE + Y list is provided
}
