% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OHLC.R
\name{impute_OHLC}
\alias{impute_OHLC}
\title{Impute missing values of an OHLC time series on a rolling window basis based on a Gaussian AR(1) model}
\usage{
impute_OHLC(
  y_OHLC,
  rolling_window = 252,
  remove_outliers = FALSE,
  outlier_prob_th = 0.001,
  tol = 1e-10,
  maxiter = 100
)
}
\arguments{
\item{y_OHLC}{Time series object coercible to a numeric matrix (e.g., \code{zoo} or \code{xts}) 
with four columns denoting the prices Op, Hi, Lo, Cl.}

\item{rolling_window}{Rolling window length (default is \code{252}).}

\item{remove_outliers}{Logical value indicating whether to detect and remove outliers.}

\item{outlier_prob_th}{Threshold of probability of observation to declare an outlier (default is \code{1e-3}).}

\item{tol}{Positive number denoting the relative tolerance used as stopping criterion (default is \code{1e-8}).}

\item{maxiter}{Positive integer indicating the maximum number of iterations allowed (default is \code{100}).}
}
\value{
Imputed OHLC prices.
}
\description{
Impute inner missing values (excluding leading and trailing ones) 
             of an OHLC time series on a rolling window basis. This is a wrapper 
             of the functions \code{\link{impute_AR1_Gaussian}} and 
             \code{\link{impute_rolling_AR1_Gaussian}}.
}
\seealso{
\code{\link{impute_AR1_Gaussian}}, \code{\link{impute_rolling_AR1_Gaussian}}
}
\author{
Daniel P. Palomar
}
