% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/v0_preprocessing.R
\name{coding}
\alias{coding}
\alias{noncoding}
\alias{inframes}
\alias{outofframes}
\title{Filter out coding and non-coding clonotype sequences}
\usage{
coding(.data)

noncoding(.data)

inframes(.data)

outofframes(.data)
}
\arguments{
\item{.data}{The data to be processed. Can be \link{data.frame},
\link[data.table:data.table]{data.table::data.table}, or a list of these objects.

Every object must have columns in the immunarch compatible format.
\link{immunarch_data_format}

Competent users may provide advanced data representations:
DBI database connections, Apache Spark DataFrame from "copy_to" or a list
of these objects. They are supported with the same limitations as basic objects.

Note: each connection must represent a separate repertoire.}
}
\value{
Filtered data frame.
}
\description{
Filter out clonotypes with non-coding, coding, in-frame or out-of-frame CDR3 sequences:

\code{coding()} - remove all non-coding sequences (i.e., remove all sequences with stop codons and frame shifts);

\code{noncoding()} - remove all coding sequences (i.e., leave sequences with stop codons and frame shifts only);

\code{inframes()} - remove all out-of-frame sequences (i.e., remove all sequences with frame shifts);

\code{outofframes()} - remove all in-frame sequences (i.e., leave sequences with frame shifts only).

Note: the function will remove all clonotypes sequences with NAs in the CDR3 amino acid column.
}
\examples{
data(immdata)
immdata_cod <- coding(immdata$data)
immdata_cod1 <- coding(immdata$data[[1]])
}
\concept{preprocessing}
