% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mada.r
\name{mada}
\alias{mada}
\title{Manifold-Adaptive Local Dimension Estimation.}
\usage{
mada(x, k = NULL, comb = "average", DM = FALSE, local = FALSE, maxDim = 5)
}
\arguments{
\item{x}{data matrix or distance matrix given by as.matrix(dist(x)).}

\item{k}{k-NN parameter.}

\item{comb}{'average', 'median' or 'vote' for combining local estimates when global estimate is required.}

\item{DM}{whether \code{'x'} is distance matrix or not. logical.}

\item{local}{logical. If \code{TRUE}, a vector of local dimensions at each sample point is returned.}

\item{maxDim}{maximum of the candidate dimensions.}
}
\value{
Estimated local or global intrinsic dimension.
}
\description{
\code{mada} estimates local information dimension of given dataset based on 
the first order expansion of probability mass function.
}
\details{
A variant of fractal dimension called the local information dimension is considered.
The local information dimension is estimated by using the probability mass function.
The function \code{mada} considers first order expansion of the probability mass around
the inspection point, and it estimates the local information dimension by using two different
radii from the inspection point.
}
\examples{
## local intrinsic dimension estimate
tmp <- gendata(DataName='ldbl',n=300)
x <- tmp$x
estmada <- mada(x=x,local=TRUE)
head(estmada)  ## estimated local intrinsic dimensions by mada
head(tmp$tDim) ## true local intrinsic dimensions
}
\references{
A. M. Farahmand, C. Szepesvari and J-Y. Audibert.
 Manifold-adaptive dimension estimation. International Conference on Machine Learning, 2007.
}
\author{
Hideitsu Hino \email{hideitsu.hino@gmail.com}
}
