% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-grapply.R
\name{gridensity}
\alias{gridensity}
\alias{grapply}
\alias{grapply,data.frame,SpatRaster-method}
\alias{grapply,data.frame,trigrid-method}
\alias{grapply,matrix,SpatRaster-method}
\alias{grapply,matrix,trigrid-method}
\alias{grapply,data.frame,missing-method}
\alias{grapply,matrix,missing-method}
\title{Icosahedral grid-based density estimation
Spatial density estimation algorithm based on rotation of icosahedral grids.}
\usage{
gridensity(x, y, out, trials = 100, FUN = mean)

grapply(x, out, ...)

\S4method{grapply}{data.frame,SpatRaster}(
  x,
  out,
  y,
  coords = c("long", "lat"),
  iter = 100,
  FUN = function(x) table(x$cell),
  APP = mean,
  miss = NA,
  APP.args = NULL,
  counter = TRUE,
  FUN.args = NULL
)

\S4method{grapply}{data.frame,trigrid}(
  x,
  out,
  y = out,
  coords = c("long", "lat"),
  iter = 100,
  FUN = function(x) table(x$cell),
  APP = mean,
  miss = NA,
  APP.args = NULL,
  counter = TRUE,
  FUN.args = NULL
)

\S4method{grapply}{matrix,SpatRaster}(x, out, ...)

\S4method{grapply}{matrix,trigrid}(x, out, ...)

\S4method{grapply}{data.frame,missing}(x, out, y, ...)

\S4method{grapply}{matrix,missing}(x, out, y, ...)
}
\arguments{
\item{x}{Matrix of longitude, latitude data, \code{\link[sf:sf]{sf}} class, or \code{\link[sp:SpatialPoints]{SpatialPoints}} Point cloud.}

\item{y}{\code{\link{trigrid}} or \code{\link{hexagrid}} An icosahedral grid.}

\item{out}{\code{\link{trigrid}}, \code{\link{hexagrid}} or \code{\link[terra:rast]{SpatRaster}}output structure. If not given, then the input argument}

\item{trials}{\code{numeric} value, the number of iterations.}

\item{FUN}{\code{function} The function to be applied on the iteration results. It defaults to the number of points, but it can be used to}

\item{...}{Arguments passed to class-specific methods.}

\item{coords}{\code{character} Column names to find longitude and latiude variables in \code{x}.}

\item{iter}{\code{numeric} Value, the number of iterations.}

\item{APP}{\code{function} The function to be applied on the iteration results. If set to \code{NULL}, it will return the stack of results for subsequent processing.}

\item{miss}{\code{numeric} A single default value used in positions in \code{out} where no value is produced by \code{FUN} in an iteration trial.}

\item{APP.args}{\code{list} Additional arguments passed to \code{APP}.}

\item{counter}{\code{logical} Should a loop counter be shown?}

\item{FUN.args}{\code{list} Additional arguments passed to \code{FUN}.}
}
\value{
Either named numeric vector, or a \code{\link[terra:rast]{SpatRaster}} object. If FUN is set to \code{NULL}, the output will be either a \code{matrix} or \code{\link[terra:rast]{SpatRaster}}.
}
\description{
Any points set can be binned to an icosahedral grid (i.e. number of incidences can be counted), which will be dependent on the exact positions of grid cells. Rotating the grid in 3d space will result in a different distribution of counts. This distribution can be resampled to a standard orientation structure. The size of the icosahedral grid cells act as a bandwidth parameter.

Discretization with iteratively rotated icosahedral grids
}
\details{
The implemented algorithm 1) takes a point cloud (\code{x})) and an icosahedral grid \code{y} 2) randomly rotates the icosahedral grid, 3) looks up the points falling on grid cells, 4) resamples the grid to a constant orientation object (either \code{\link{trigrid}}, \code{\link{hexagrid}} or \code{\link[terra:rast]{SpatRaster}}). Steps 2-4 are repeated \code{trial} times, and then \code{FUN} is applied to every vector of values that have same spatial position.

Simple discretization of spatial data is subject to error due to the random assignment to grid cells. \code{grapply} offers a framework for the Monte Carlo estimation of the expectation of a function that normally can be applied to
a discretized set of points. This function \code{FUN} takes the input the \code{data.frame} (or \code{matrix}, which will be coerced into one) as argument, with the addition of a new variable \code{cells}, which includes
face identifiers for the point set given the random grid rotation (the output of \code{locate}). See examples for a step-by-step description.
}
\examples{
# example to be run if terra is present
if(requireNamespace("terra", quietly=TRUE)){

 # randomly generated points
 x <- rpsphere(100, output="polar")

 # bandwidth grid
 gr <- hexagrid(deg=13)

 # output structure
 out <- terra::rast(res=5)

 # Manual example - for understanding what FUN is doing
 cell<- locate(gr, x)
yNew <- cbind(as.data.frame(x), cell=cell)
 # this is the default function (here named CellCount)
 CellCount <- function(x) table(x$cell)
 counts <- CellCount(yNew)
 # create facelayer
 fl <- facelayer(gr, counts)

 # and resample
 oneOut <- icosa::resample(fl, out)
 terra::plot(oneOut, main="Density with default grid orientation")
 points(x, pch=3, col="red")

 # for density estimation
 o <- grapply(x=x, out=out,y=gr,  iter=7, FUN=CellCount, miss=0)

 # visualize results
 terra::plot(o)
 points(x, pch=3, col="red")
}

}
