% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iclogcondist_functions.R
\name{find_dir_deriv}
\alias{find_dir_deriv}
\title{Compute Directional Derivatives for Active Set Algorithm}
\usage{
find_dir_deriv(diff_tau, first_order)
}
\arguments{
\item{diff_tau}{A numeric vector containing the differences between consecutive time points (tau).}

\item{first_order}{A numeric vector representing the first-order derivatives at each time point.}
}
\value{
A numeric vector of length \code{length(diff_tau) + 1} representing the directional derivatives for the active set algorithm.
}
\description{
This function computes the directional derivatives for the active set algorithm used in the estimation 
of the distribution function under log-concavity with interval-censored data.
The calculation takes advantage of the specific structure of the basis matrix, making it efficient to compute in \code{O(n)} time complexity.
}
