% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ices_get.R, R/ices_get_jwt.R,
%   R/ices_patch_jwt.R, R/ices_post.R, R/ices_post_jwt.R, R/ices_request_jwt.R
\name{ices_get}
\alias{ices_get}
\alias{ices_get_jwt}
\alias{ices_patch_jwt}
\alias{ices_post}
\alias{ices_post_jwt}
\alias{ices_request_jwt}
\title{ices_request_jwt}
\usage{
ices_get(
  url,
  retry = TRUE,
  quiet = FALSE,
  verbose = FALSE,
  content = TRUE,
  use_token = FALSE
)

ices_get_jwt(
  url,
  username = NULL,
  retry = TRUE,
  quiet = FALSE,
  verbose = FALSE,
  jwt = NULL
)

ices_patch_jwt(
  url,
  body = list(),
  encode = "json",
  username = NULL,
  retry = TRUE,
  quiet = FALSE,
  verbose = FALSE,
  jwt = NULL
)

ices_post(
  url,
  body = list(),
  retry = TRUE,
  verbose = FALSE,
  content = TRUE,
  use_token = TRUE,
  encode = "multipart"
)

ices_post_jwt(
  url,
  body = list(),
  encode = "json",
  username = NULL,
  retry = TRUE,
  quiet = FALSE,
  verbose = FALSE,
  jwt = NULL
)

ices_request_jwt(
  type = c("GET", "POST", "PATCH"),
  url,
  body = NULL,
  encode = c("multipart", "form", "json", "raw"),
  username = NULL,
  retry = TRUE,
  quiet = FALSE,
  verbose = FALSE,
  jwt = NULL
)
}
\arguments{
\item{url}{the url to make the request to}

\item{retry}{if initial request fails, should a retry be made, Default: TRUE}

\item{quiet}{suppress informative messages to the console}

\item{verbose}{should the http request return verbose output}

\item{content}{logical, if TRUE the content of the response is returned, if FALSE the http response object is returned}

\item{use_token}{logical, if TRUE the token is used, if FALSE the token is not used}

\item{username}{the ices username to perform the request as,
Default: \code{getOption("ices.username")}}

\item{jwt}{option to supply a token bypassing the ices_token() route, if "" no token is used}

\item{body}{optional body of request}

\item{encode}{If the body is a named list, how should it be encoded?}

\item{type}{the type of request to make, GET, POST or PATCH}
}
\value{
http response object
}
\description{
Perform a get request to a url using a javascript web token for authentication
}
\examples{
\dontrun{
# this function is interactive and asks the user for a password
ices_request_jwt("GET", "https://taf.ices.dk/vms/api/gearwidths")
ices_get_jwt("https://taf.ices.dk/vms/api/gearwidths")

the top level function
ices_get("https://taf.ices.dk/vms/api/gearwidths", content = FALSE, use_token = TRUE)
ices_get("https://taf.ices.dk/vms/api/gearwidths", content = TRUE)
}
}
\seealso{
\code{\link[icesConnect]{ices_token}}
\code{\link[httr]{GET}},\code{\link[httr]{add_headers}},\code{\link[httr]{stop_for_status}},\code{\link[httr]{status_code}}
}
