% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/icdglm.fit.R
\name{icdglm.fit}
\alias{icdglm.fit}
\title{EM by the Method of Weights for Incomplete Data in GLMs (Algorithm)}
\usage{
icdglm.fit(x, y, weights = rep.int(1, NROW(x)), indicator = rep.int(0, NROW(x)),
       family = binomial(link = "logit"), control=list())
}
\arguments{
\item{x}{a vector, matrix, list or data frame containing the independent variables}

\item{y}{a vector of integers or numerics. This is the dependent variable.}

\item{weights}{a vector which attaches a weight to each observation. For incomplete data, this is obtained from \code{\link{expand_data}}.}

\item{indicator}{a vector that indicates which observations belong to each other. This is obtained from \code{\link{expand_data}}.}

\item{family}{family for glm.fit. See \code{\link{glm}} or \code{\link{family}} for more details. Default is \code{binomial(link = "logit")}.}

\item{control}{a list of control characteristics. See \code{\link{glm.control}} for further information. Default settings are: \code{epsilon = 1e-10, maxit = 100, trace = FALSE}.}
}
\value{
\code{icdglm.fit} returns a list with the following elements:
\itemize{
\item{x}{a matrix of numerics containing all independent variables}
\item{y}{a vector of numerics containing the dependent variable}
\item{new.weights}{the new weights obtained in the final iteration of \emph{icdglm.fit}}
\item{indicator}{a vector of integers indicating which observations belong to each other}
\item{glm.fit.data}{typical \code{glm.fit} output for the last iteration. See \code{\link{glm.fit}} for further information.}
\item{coefficients}{a named vector of coefficients}
\item{qr}{QR Decomposition of the information matrix}
\item{residuals}{the residuals of the final iteration}
\item{fitted.values}{the fitted mean values, obtained by transforming the linear predictors by the inverse of the link function.}
\item{rank}{the numeric rank of the fitted linear model}
\item{family}{the \link{family} object used.}
\item{linear.predictors}{the linear fit on link scale}
\item{deviance}{up to a constant, minus twice the maximized log-likelihood. Where sensible, the constant is chosen so that a saturated model has deviance zero.}
\item{aic}{see \link{glm}}
\item{null.deviance}{The deviance for the null model, comparable with deviance. The null model will include the offset, and an intercept if there is one in the model. Note that this will be incorrect if the link function depends on the data other than through the fitted mean: specify a zero offset to force a correct calculation.}
\item{iter}{an integer containing the number of iterations in \emph{icdglm.fit} before convergence}
\item{weights}{the working weights, that is the weights in the final iteration of the IWLS fit.}
\item{prior.weights}{the weights initially supplied, a vector of 1s if none were.}
\item{df.residual}{the residual degrees of freedom from the initial data set}
\item{df.null}{the residual degrees of freedom from initial data set for the null model}
\item{model}{model frame}
\item{converged}{TRUE if \emph{icdglm} converged.}
\item{call}{the match call}
\item{formula}{the formula supplied}
\item{terms}{the \emph{\link{terms}} object used}
\item{data}{the data argument}
\item{control}{the value of the \emph{control} argument used}
}
}
\description{
This function applies the EM algorithm by the method of weights to incomplete data in a general linearized model.
}
\examples{
data(TLI.data)
          complete.data <- expand_data(data = TLI.data[, 1:3],
                                       y = TLI.data[, 4],
                                       missing.x = 1:3,
                                       value.set = 0:1)
          example1 <- icdglm.fit(x = complete.data$data[, 1:3],
                                 y = complete.data$data[, 4],
                                 weights = complete.data$weights,
                                 indicator = complete.data$indicator,
                                 family = binomial(link = "logit"),
                                 control = list(epsilon = 1e-10,
                                                maxit = 100, trace = TRUE))
}
\references{
Ibrahim, Joseph G. (1990). \emph{Incomplete Data in Generalized Linear Models}. Journal of the American Statistical Association, Vol.85, No. 411, pp. 765 - 769.
}
\seealso{
\code{\link{expand_data}}, \code{\link{icdglm}}
\code{\link{glm.fit}}, \code{\link{glm.control}}, \code{\link{summary.glm}}
}

