% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/icc_dep_test.R
\name{icc_dep_test}
\alias{icc_dep_test}
\title{Tests the equality of dependent ICCs}
\usage{
icc_dep_test(
  data,
  ry,
  rind,
  rtype,
  alpha = 0.05,
  Wald = FALSE,
  WL = 1:2,
  Boot = FALSE,
  nboot = 500,
  Perm = FALSE,
  nperm = 100,
  parallel = TRUE,
  workers = 15,
  future_seed = NULL,
  progress = TRUE
)
}
\arguments{
\item{data}{A data frame with (at least) three columns: the outcome, the subject and the setting identifiers.}

\item{ry}{Character string. The outcome variable.}

\item{rind}{Character string. The subject identifier.}

\item{rtype}{Character string. The setting identifier.}

\item{alpha}{Numeric. Significance level. Default to 0.05.}

\item{Wald}{Logical. Should the Wald test be run? Default is FALSE}

\item{WL}{Vector of length two. Which pair of settings should be compared using the Wald test? The first two settings are the default.}

\item{Boot}{Logical. Should bootstrap be run? Default is FALSE.}

\item{nboot}{Numeric. Number of bootstrap resamples. Default is 500.}

\item{Perm}{Logical. Should permutations test be run? Default value is FALSE.}

\item{nperm}{Numeric. Number of permutations. Default value is 100.}

\item{parallel}{Logical. Use parallel computation? Default value is TRUE.}

\item{workers}{Numeric. Number of cores used in parallelization. Default value is 15.}

\item{future_seed}{Logical/Integer. The seed to be used for parallellization. Further details in \code{\link[furrr]{furrr_options}}.}

\item{progress}{Logical. If TRUE a progress bar is created while computing bootstrap and permutations. Default value is TRUE}
}
\value{
The output is a list with the following components:
\itemize{
  \item \code{Model}. Object of class lme with the fitted model estimates.
  \item \code{Estimates}. List containing three objects: 1) a matrix with the ICCs etimates; 2) the variance-covariance matrix of the ICC estimates; 3) Confidence intervals of the ICC estimates.
  \item \code{p_values}. List with the computed p-values testing the equality of the ICCs. 
  \item \code{boot_res}. List with three objects: 1) bootstrap estimates of the ICCs; 2) mean of the bootstrap ICC estimates; 3) variance-covariance matrix of the ICC estimates obtained by bootstrapping.
  \item \code{perm_res}. List with three elements: 1) P-value obtained by permutations to test the equality of the ICCs; 2) Vector containing the sum of the squared differences between the ICCs obtained in each permutation; 3) the sum of the squared differences between the ICCs obtained in the original sample. 
}
}
\description{
Tests the equality of dependent ICCs
}
\details{
The variance components required for ICC estimation are obtained using a linear mixed-effects model that accounts for correlations across settings.
The null hypothesis of equality between dependent ICCs is evaluated through the following methods:
 
 - Wald test based on Fisher’s Z and Konishi–Gupta transformations, using either asymptotic or bootstrap standard errors;
 
 - Chi-square test with asymptotic or bootstrap standard errors;
 
 - Permutation test.
}
\examples{
sin_res_b<-icc_dep_test(sin_data,ry="Sinuosity",rind="id",rtype="Section",alpha=0.05,Wald=TRUE,
WL=1:2,)

\donttest{
sin_res<-icc_dep_test(sin_data,ry="Sinuosity",rind="id",rtype="Section",alpha=0.05,Wald=TRUE,
                     WL=1:2,Boot=TRUE,nboot=500,Perm=TRUE,nperm=100,
                     parallel=TRUE,workers=15,future_seed = NULL,progress=TRUE)



dia_res<-icc_dep_test(cccrm::bpres,ry="DIA",rind="ID",rtype="METODE",alpha=0.05,Wald=TRUE,
WL=1:2,Boot=TRUE,nboot=500,Perm=TRUE,nperm=100,
parallel=TRUE,workers=15,future_seed = NULL,progress=TRUE)


}
}
