% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LRT.R
\name{ICC_LR_test}
\alias{ICC_LR_test}
\title{Tests the equality of dependent ICCs using the likelihood ratio test (LRT)}
\usage{
ICC_LR_test(data, ry = "y", rind = "ind", rtype = "type", optimizer = "nlminb")
}
\arguments{
\item{data}{A data frame with (at least) three columns: the outcome, the subject and the setting identifiers.}

\item{ry}{Character string. The outcome variable.}

\item{rind}{Character string. The subject identifier.}

\item{rtype}{Character string. The setting identifier.}

\item{optimizer}{Optimization function to use. For further details see \code{\link[bbmle]{mle2}}}
}
\value{
The output is an object of class htest with the following components:
\itemize{
  \item \code{null.value}. Vector. The value of the ICC in the null hypothesis of equality of ICCs.
  \item \code{estimate}. Vector. The estimates of the ICC
  \item \code{statistic}. Numerical. The value of the LR statistic.
  \item \code{p.value}. Numerical. The value of the LR statistic.
  }
}
\description{
Tests the equality of dependent ICCs using the likelihood ratio test (LRT)
}
\details{
The null hypothesis of equality of dependent ICCs is tested using the likelihood ratio test (LRT) proposed in Donner and Zou (2002).
}
\examples{
\donttest{
sin_res<-ICC_LR_test(sin_data,ry="Sinuosity",rind="id",rtype="Section")

}
}
\references{
{
Donner, A. and Zou, G. (2002). Testing the equality of dependent intraclass correlation coefficients. Journal of the Royal Statistical Society: Series D (The Statistician), 51(3):367–379

}
}
