% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/segment_count_dist.R
\name{segment_count_dist}
\alias{segment_count_dist}
\title{Compute probability distribution of IBD segment count}
\usage{
segment_count_dist(
  pedigree,
  ids = pedtools::leaves(pedigree),
  states = "ibd",
  ibd_state = 1L,
  chromosome_length = 267.77,
  convolve = TRUE
)
}
\arguments{
\item{pedigree}{Pedigree in \code{\link[pedtools:ped]{pedtools::ped}} form.}

\item{ids}{Ids for which IBD is observed. Default is \code{pedtools::leaves(pedigree)}.}

\item{states}{One of \code{"ibd"} (default), \code{"kappa"}, \code{"identity"} or \code{"detailed"}.}

\item{ibd_state}{Default is 1.}

\item{chromosome_length}{Default is 267.77 cM (an estimate of the length of chromosome 1).}

\item{convolve}{Should the distribution of the sum (across chromosomes) be obtained?}
}
\value{
object of class \code{segment_count_dist}
}
\description{
The \code{segment_count_dist} function computes the probability distribution
of the number of IBD segments
(i.e., the count of IBD intervals) between pairs of individuals
in a pedigree, for a given IBD state and chromosome length(s).
}
\details{
This function is analogous to \code{\link[=total_ibd_dist]{total_ibd_dist()}} but focuses on
the number of IBD segments rather than the total IBD length.
}
\examples{
ped_hs <- pedtools::halfSibPed()

dist <- segment_count_dist(ped_hs, chromosome_length = 100)
dist
plot(dist)
E(dist)
sd(dist)

r <- r_cibd(n = 1e4, pedigree = ped_hs, chromosome_length = 100)
mean(r$stats$segment_count)
sd(r$stats$segment_count)

}
\seealso{
\code{\link[=total_ibd_dist]{total_ibd_dist()}} for the distribution of IBD \emph{length}.
}
