% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ifcb_summarize_biovolumes.R
\name{ifcb_summarize_biovolumes}
\alias{ifcb_summarize_biovolumes}
\title{Summarize Biovolumes and Carbon Content from IFCB Data}
\usage{
ifcb_summarize_biovolumes(
  feature_folder,
  mat_files = NULL,
  class2use_file = NULL,
  hdr_folder = NULL,
  custom_images = NULL,
  custom_classes = NULL,
  micron_factor = 1/3.4,
  diatom_class = "Bacillariophyceae",
  diatom_include = NULL,
  marine_only = FALSE,
  threshold = "opt",
  feature_recursive = TRUE,
  mat_recursive = TRUE,
  hdr_recursive = TRUE,
  drop_zero_volume = FALSE,
  feature_version = NULL,
  use_python = FALSE,
  verbose = TRUE,
  mat_folder = deprecated()
)
}
\arguments{
\item{feature_folder}{Path to the folder containing feature files (e.g., CSV format).}

\item{mat_files}{(Optional) A character vector of full paths to class or manual annotation files, or a single path to a folder containing such files.}

\item{class2use_file}{(Optional) A character string specifying the path to the file containing the class2use variable (default NULL). Only needed when summarizing manual MATLAB results.}

\item{hdr_folder}{(Optional) Path to the folder containing HDR files. Needed for calculating cell, biovolume and carbon concentration per liter.}

\item{custom_images}{(Optional) A character vector of image filenames in the format DYYYYMMDDTHHMMSS_IFCBXXX_ZZZZZ,
where "XXX" represents the IFCB number and "ZZZZZ" represents the ROI number.
These filenames should match the \code{roi_number} assignment in the \code{feature_files} and can be
used as a substitute for MATLAB files.}

\item{custom_classes}{(Optional) A character vector of corresponding class labels for \code{custom_images}.}

\item{micron_factor}{Conversion factor from microns per pixel (default: 1/3.4).}

\item{diatom_class}{A string vector of diatom class names in the World Register of Marine Species (WoRMS). Default is "Bacillariophyceae".}

\item{diatom_include}{Optional character vector of class names that should always be treated as diatoms,
overriding the boolean result of \code{ifcb_is_diatom}. Default: NULL.}

\item{marine_only}{Logical. If TRUE, restricts the WoRMS search to marine taxa only. Default is FALSE.}

\item{threshold}{Threshold for classification (default: "opt").}

\item{feature_recursive}{Logical. If TRUE, the function will search for feature files recursively within the \code{feature_folder}. Default is TRUE.}

\item{mat_recursive}{Logical. If TRUE, the function will search for MATLAB files recursively when the \code{mat_files} is a folder. Default is TRUE.}

\item{hdr_recursive}{Logical. If TRUE, the function will search for HDR files recursively within the \code{hdr_folder} (if provided). Default is TRUE.}

\item{drop_zero_volume}{Logical. If \code{TRUE}, rows where \code{Biovolume} equals zero (e.g., artifacts such as smudges on the flow cell) are removed. Default: \code{FALSE}.}

\item{feature_version}{Optional numeric or character version to filter feature files by (e.g. 2 for "_v2"). Default is NULL (no filtering).}

\item{use_python}{Logical. If \code{TRUE}, attempts to read the \code{.mat} file using a Python-based method. Default is \code{FALSE}.}

\item{verbose}{A logical indicating whether to print progress messages. Default is TRUE.}

\item{mat_folder}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}
Use \code{mat_files} instead.}
}
\value{
A data frame summarizing aggregated biovolume and carbon content per class per sample.
Columns include 'sample', 'classifier', 'class', 'biovolume_mm3', 'carbon_ug', 'ml_analyzed',
'biovolume_mm3_per_liter', and 'carbon_ug_per_liter'.
}
\description{
This function calculates aggregated biovolumes and carbon content from Imaging FlowCytobot (IFCB)
samples based on biovolume information from feature files. Images are grouped into classes either
based on MATLAB classification, manually annotated files, or a user-supplied list of images and
their corresponding class labels (e.g. from a CNN model).
}
\details{
This function performs the following steps:
\enumerate{
\item Extracts biovolumes and carbon content from feature and classification results using \code{ifcb_extract_biovolumes}.
\item Optionally incorporates volume data from HDR files to calculate volume analyzed per sample.
\item Computes biovolume and carbon content per liter of sample analyzed.
}

The MATLAB classification or manual annotation files are generated by the \code{ifcb-analysis} repository
(Sosik and Olson 2007). Users can optionally provide a \strong{custom classification} by supplying a vector of image filenames
(\code{custom_images}) along with corresponding class labels (\code{custom_classes}). This allows summarization
of biovolume and carbon content without requiring MATLAB classification or manual annotation files
(e.g. results from a CNN model).

Biovolumes are converted to carbon according to Menden-Deuer and Lessard 2000
for individual regions of interest (ROI), applying different conversion factors to diatoms and
non-diatom protists. If provided, the function also incorporates sample volume data from HDR files
to compute biovolume and carbon content per liter of sample.

If \code{use_python = TRUE}, the function tries to read the \code{.mat} file using \code{ifcb_read_mat()}, which relies on \code{SciPy}.
This approach may be faster than the default approach using \code{R.matlab::readMat()}, especially for large \code{.mat} files.
To enable this functionality, ensure Python is properly configured with the required dependencies.
You can initialize the Python environment and install necessary packages using \code{ifcb_py_install()}.
}
\examples{
\dontrun{
# Example usage:
ifcb_summarize_biovolumes("path/to/features", "path/to/mat", hdr_folder = "path/to/hdr")

# Using custom classification result:
images <- c("D20220522T003051_IFCB134_00002",
            "D20220522T003051_IFCB134_00003")
classes = c("Mesodinium_rubrum",
            "Mesodinium_rubrum")

ifcb_summarize_biovolumes(feature_folder = "path/to/features",
                          hdr_folder = "path/to/hdr",
                          custom_images = images,
                          custom_classes = classes)
}

}
\references{
Menden-Deuer Susanne, Lessard Evelyn J., (2000), Carbon to volume relationships for dinoflagellates, diatoms, and other protist plankton, Limnology and Oceanography, 3, doi: 10.4319/lo.2000.45.3.0569.

Sosik, H. M. and Olson, R. J. (2007), Automated taxonomic classification of phytoplankton sampled with imaging-in-flow cytometry. Limnol. Oceanogr: Methods 5, 204–216.
}
