% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/colourpalettes.R
\name{emphasize_pal_colour}
\alias{emphasize_pal_colour}
\title{Emphasize a level or interval of a colour palette}
\usage{
emphasize_pal_colour(n, k, cat = TRUE, ncat = 5, fn)
}
\arguments{
\item{n}{the number of colours to draw from the palette}

\item{k}{the index of the colour to emphasize}

\item{cat}{logical indicator if palette is categorical or numeric}

\item{ncat}{the number of intervals to use for continuous palettes}

\item{fn}{the colour palette function to use}
}
\value{
a colour palette, with one level emphasized (or range for numeric)
}
\description{
Emphasize a level or interval of a colour palette
}
\examples{
pal <- inzpalette("bright")
plot(1:5, pch = 19, col = emphasize_pal_colour(5, 2, fn = pal))
}
\author{
Tom Elliott
}
