% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MainFun.R
\name{ggCompleteness}
\alias{ggCompleteness}
\title{ggplot for depicting sample completeness profiles}
\usage{
ggCompleteness(output)
}
\arguments{
\item{output}{output obtained from the function \code{Completeness}.}
}
\value{
a figure depicting the estimated sample completeness with respect to the order q.
}
\description{
\code{ggCompleteness} is a \code{ggplot2} extension for \code{Completeness} object to plot sample completeness with order q between 0 and 2.
}
\examples{
\donttest{
## Sample completeness profile for abundance data
data(Data_spider)
SC_out1 <- Completeness(data = Data_spider, datatype = "abundance")
ggCompleteness(SC_out1)
}

## Sample completeness profile for incidence raw data
data(Data_woody_plant)
SC_out2 <- Completeness(data = Data_woody_plant, datatype = "incidence_raw")
ggCompleteness(SC_out2)


}
