% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aux_agg2climatic.R
\name{agg2climatic}
\alias{agg2climatic}
\title{Aggregates a data frame to climatic resolution}
\usage{
agg2climatic(df, col_name, fun, allow_na = 0, start_month = 1, end_month = 12)
}
\arguments{
\item{df}{data frame with class Date or POSIXct in the first column.}

\item{col_name}{string (vector) with the name(s) of the column(s) to aggregate.}

\item{fun}{string (vector) containing the name(s) of function(s) to use: mean, min, max, sum, last or first.}

\item{allow_na}{optional. Numeric value with the maximum allowed number of NA_real_ values. By default the function will not tolerate any NA_real_ in an aggregation period (and will return NA_real_ instead).}

\item{start_month}{numeric value defining the first month of the annually period. Default sets to 1 (January).}

\item{end_month}{numeric value defining the last month of the annually period. Default sets to 12 (December).}
}
\value{
A data frame with the Date and the aggregated variable(s).
}
\description{
Aggregates a data frame to climatic resolution
}
\keyword{internal}
