% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/select_which.R
\name{select_which}
\alias{select_which}
\title{Select columns satisfying a condition}
\usage{
select_which(DT, Which, .and.dots = NULL, checkDT = TRUE, .and.grep = NULL)
}
\arguments{
\item{DT}{A \code{data.table}.}

\item{Which}{A function that takes a vector and returns \code{TRUE} or \code{FALSE}. \code{TRUE} columns are selected.}

\item{.and.dots}{Optional extra columns to include. May be a character vector of \code{names(DT)} or numeric (positions) or logical. If provided, the columns so added (if they do not satisfy \code{Which}) will be after all the columns \code{Which} do so satisfy.}

\item{checkDT}{If \code{TRUE} (the default), an informative error message is provided if \code{DT} is not a \code{data.table}.}

\item{.and.grep}{A character vector of regular expressions to match to the names
of \code{DT}. The corresponding columns will be included in the result.}
}
\value{
\code{DT} with the selected variables.
}
\description{
Select columns satisfying a condition
}
\examples{
library(data.table)
DT <- data.table(x = 1:5,
                 y = letters[1:5],
                 AB = c(NA, TRUE, FALSE))
select_which(DT, anyNA, .and.dots = "y")
}
