% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dist_ll.R
\name{dist_ll}
\alias{dist_ll}
\title{Distributional Likelihood for Hurdle Model Count Data Regression}
\usage{
dist_ll(y, hurd = Inf, lam = NULL, size = 1, mu = NULL, xi = NULL,
  sigma = NULL, dist = c("poisson", "nb", "lognormal", "gpd"), g.x = F,
  log = T)
}
\arguments{
\item{y}{numeric response vector.}

\item{hurd}{numeric threshold for 'extreme' observations of two-hurdle 
models. \code{Inf} for one-hurdle models.}

\item{lam}{current value for the poisson likelihood lambda parameter.}

\item{size}{size parameter for negative binomial likelihood distributions.}

\item{mu}{current value for the negative binomial or log normal likelihood 
mu parameter.}

\item{xi}{current value for the generalized pareto likelihood xi parameter.}

\item{sigma}{current value for the generalized pareto likelihood sigma 
parameter.}

\item{dist}{character specification of response distribution.}

\item{g.x}{logical operator. \code{TRUE} if operating within the third 
component of the likelihood function (the likelihood of 'extreme' observations).}

\item{log}{logical operator. if \code{TRUE}, probabilities p are given 
as log(p).}
}
\value{
The log-likelihood of the zero-inflated Poisson fit for the
current iteration of the MCMC algorithm.
}
\description{
\code{dist_ll} is the data likelihood fuction for hurdle model 
regression using \code{\link{hurdle}}.
}
\details{
Currently, Poisson, Negative Binomial, log-Normal, 
and Generalized Pareto distributions are available.
}
\seealso{
\code{\link{hurdle}}
}
\author{
Taylor Trippe <\email{ttrippe@luc.edu}> \cr
Earvin Balderama <\email{ebalderama@luc.edu}>
}
