% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/include_shape.R
\name{include_shape}
\alias{include_shape}
\title{Shape layer}
\usage{
include_shape(
  label,
  value = "hexagon",
  size = 5.08,
  position = NA,
  border_color = "black",
  border_width = 1,
  background = NA,
  units = "cm",
  panel_color = NA,
  panel_size = NA
)
}
\arguments{
\item{label}{label output (table)}

\item{value}{type of shape (string: "hexagon")}

\item{size}{shape size (numeric: 5.08)}

\item{position}{position coordinate (numeric: NA)}

\item{border_color}{image color (string: "black")}

\item{border_width}{shape line width (numeric: 1)}

\item{background}{background color (string: "red")}

\item{units}{units for shape (string: "cm")}

\item{panel_color}{panel color (string: NA)}

\item{panel_size}{panel size (numeric: NA)}
}
\value{
data frame
}
\description{
Insert shape in label
}
\examples{

library(huito)

label <- label_layout(data = NA
               , size = c(10, 2.5)
               , background = "yellow"
               ) \%>\%
         include_shape(
               value = "hexagon"
               , position = c(1.2, 1.25)
               , background = "red"
               , border_width = 1
               , size = 2.4
               #, panel_size = 2.4*1.157175
               )
               
label \%>\% label_print("sample")

ts <- label$opts
               
}
