% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chas.R
\name{get_hud_chas_entityid_list}
\alias{get_hud_chas_entityid_list}
\title{Get HUD Comprehensive Housing Affordability Strategy (CHAS) data at the Place, MCD, County, State, National Level from HUD.}
\usage{
get_hud_chas_entityid_list(
  stateid,
  geo_lvl,
  hud_key = Sys.getenv("HUD_API_KEY")
)
}
\arguments{
\item{stateid}{Character string containing the 'fips_code' for the State.}

\item{geo_lvl}{Character string indicating either "county", "MDC", or "city".}

\item{hud_key}{Character string indicating your API key from HUD.}
}
\value{
A list of data tables containing fair market rent data from HUD.
}
\description{
Provides a data.table containing the entityIds for all of the counties within a given state for the Comprehensive Housing Affordability Strategy (CHAS) data from HUD.
}
\details{
Provides fair market rent data at the County and MSA level from HUD.
}
\examples{
\dontrun{
library(hudr)

hud_key <- Sys.getenv("HUD_API_KEY")

chas_cnty_lst_dt <- get_hud_chas_entityid_list(stateid = "53",
                                               geo_lvl = "county",
                                               hud_key = hud_key)
}
}
\author{
Paul Richardson
}
