% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hsstan-package.R
\docType{package}
\name{hsstan-package}
\alias{hsstan-package}
\title{Hierarchical shrinkage Stan models for biomarker selection}
\description{
The \strong{hsstan} package provides linear and logistic regression models
penalized with hierarchical shrinkage priors for selection of biomarkers.
Models are fitted with Stan (Carpenter et al. (2017)), which allows to
perform full Bayesian inference.
}
\details{
The package implements the horseshoe and regularized horseshoe priors
(Piironen and Vehtari (2017)), and the projection predictive selection
approach to recover a sparse set of predictive biomarkers (Piironen,
Paasiniemi and Vehtari (2020)).

The approach is particularly suited to selection from high-dimensional
panels of biomarkers, such as those that can be measured by MSMS or similar
technologies (Colombo, Valo, McGurnaghan et al. (2019), Colombo, McGurnaghan,
Blackbourn et al. (2020)).
}
\references{
B. Carpenter et al. (2017),
Stan: a probabilistic programming language,
\emph{Journal of Statistical Software}, 76 (1).
\doi{10.18637/jss.v076.i01}

J. Piironen and A. Vehtari (2017),
Sparsity information and regularization in the horseshoe and other shrinkage
priors, \emph{Electronic Journal of Statistics}, 11 (2), 5018-5051.
\doi{10.1214/17-EJS1337SI}

J. Piironen, M. Paasiniemi and A. Vehtari (2020),
Projective inference in high-dimensional problems: prediction and feature
selection, \emph{Electronic Journal of Statistics}, 14 (1), 2155-2197.
\doi{10.1214/20-EJS1711}

M. Colombo, E. Valo, S.J. McGurnaghan et al. (2019),
Biomarkers associated with progression of renal disease in type 1 diabetes,
\emph{Diabetologia}, 62 (9), 1616-1627.
\doi{10.1007/s00125-019-4915-0}

M. Colombo, S.J. McGurnaghan, L.A.K. Blackbourn et al. (2020),
Comparison of serum and urinary biomarker panels with albumin creatinin
ratio in the prediction of renal function decline in type 1 diabetes,
\emph{Diabetologia}, 63 (4), 788-798.
\doi{10.1007/s00125-019-05081-8}

M. Colombo, A. Asadi Shehni, I. Thoma et al. (2021),
Quantitative levels of serum N-glycans in type 1 diabetes and their
association with kidney disease,
\emph{Glycobiology}, 31 (5), 613-623.
\doi{10.1093/glycob/cwaa106}
}
