% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/powercalc.R
\name{pwr.snpblup}
\alias{pwr.snpblup}
\title{Wrapper function for sample size calculation}
\usage{
pwr.snpblup(
  nfathers,
  nqtl,
  h2,
  R,
  rep = 10,
  nmax = 5000,
  weights = 1,
  typeII = 0.2,
  alpha = 0.01
)
}
\arguments{
\item{nfathers}{number of half-sib families}

\item{nqtl}{number of QTL assumed}

\item{h2}{heritability captured by QTL}

\item{R}{(p x p) matrix containing theoretical correlation between SNP pairs}

\item{rep}{number of repetitions; default value 10}

\item{nmax}{maximum value for grid search; default value 5000}

\item{weights}{vector (LEN p) of SNP-specific weights or scalar if weights
are equal for all SNPs; default value 1}

\item{typeII}{type-II error level; default value 0.2}

\item{alpha}{type-I error level; default value 0.01}
}
\value{
vector of optimal sample size over all repetitions
}
\description{
Given parameters specified by the experimenter, optimal sample
  size is estimated by repeatedly applying \code{search.best.n.bisection}.
}
\details{
Sample size depends on parameters specified by the experimenter
  (number of half-sib families, number of QTL, heritability, correlation
  matrix). These values are converted into parameters required for the
  probability density function under the alternative hypothesis (beta_k !=0,
  for k selected QTL positions). As power depends on the selected QTL
  positions, these are sampled at random and power calculations are repeated.
  Afterwards the mean value is a plausible estimate of optimal sample size.

  Linear model for SNP-BLUP approach:
  \code{y = X beta + e}
  with \code{t(beta) = (beta_1, ldots, beta_p)}
  Ridge approach:
  \code{hat{beta} = (Xt X + I lambda)^{-1} Xt y}

  The identity matrix \code{I} can be replaced by a diagonal matrix
  containing SNP-specific weights yielding a generalised ridge approach.
}
\examples{
  ### input parameters specified by experimenter
  # number of half-sib families
  nfathers <- 10
  # number of assumed QTL
  nqtl <- 2
  # QTL heritability
  h2 <- 0.2
  ### correlation matrix (should depend on sire haplotypes)
  R <- AR1(100, rho = 0.1)
  ### optimal sample size in a multi-marker approach
  set.seed(11)
  pwr.snpblup(nfathers, nqtl, h2, R, rep = 1)
}
\references{
Wittenburg, Bonk, Doschoris, Reyer (2020) Design of Experiments
  for Fine-Mapping Quantitative Trait Loci in Livestock Populations. BMC
  Genetics 21:66. \doi{10.1186/s12863-020-00871-1}
}
