% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nba_stats_team_dash.R
\name{nba_teamdashptpass}
\alias{nba_teamdashptpass}
\title{\strong{Get NBA Stats API Team Dashboard Player Tracking - Passing}}
\usage{
nba_teamdashptpass(
  date_from = "",
  date_to = "",
  last_n_games = 0,
  league_id = "00",
  location = "",
  month = 0,
  opponent_team_id = 0,
  outcome = "",
  per_mode = "Totals",
  season = year_to_season(most_recent_nba_season() - 1),
  season_segment = "",
  season_type = "Regular Season",
  team_id = "1610612749",
  vs_conference = "",
  vs_division = "",
  ...
)
}
\arguments{
\item{date_from}{date_from}

\item{date_to}{date_to}

\item{last_n_games}{last_n_games}

\item{league_id}{league_id}

\item{location}{location}

\item{month}{month}

\item{opponent_team_id}{opponent_team_id}

\item{outcome}{outcome}

\item{per_mode}{per_mode}

\item{season}{season}

\item{season_segment}{season_segment}

\item{season_type}{season_type}

\item{team_id}{team_id}

\item{vs_conference}{vs_conference}

\item{vs_division}{vs_division}

\item{...}{Additional arguments passed to an underlying function like httr.}
}
\value{
Return a named list of data frames: PassesMade, PassesReceived

\strong{PassesMade}\tabular{ll}{
   col_name \tab types \cr
   TEAM_ID \tab character \cr
   TEAM_NAME \tab character \cr
   PASS_TYPE \tab character \cr
   G \tab character \cr
   PASS_FROM \tab character \cr
   PASS_TEAMMATE_PLAYER_ID \tab character \cr
   FREQUENCY \tab character \cr
   PASS \tab character \cr
   AST \tab character \cr
   FGM \tab character \cr
   FGA \tab character \cr
   FG_PCT \tab character \cr
   FG2M \tab character \cr
   FG2A \tab character \cr
   FG2_PCT \tab character \cr
   FG3M \tab character \cr
   FG3A \tab character \cr
   FG3_PCT \tab character \cr
}


\strong{PassesReceived}\tabular{ll}{
   col_name \tab types \cr
   TEAM_ID \tab character \cr
   TEAM_NAME \tab character \cr
   PASS_TYPE \tab character \cr
   G \tab character \cr
   PASS_TO \tab character \cr
   PASS_TEAMMATE_PLAYER_ID \tab character \cr
   FREQUENCY \tab character \cr
   PASS \tab character \cr
   AST \tab character \cr
   FGM \tab character \cr
   FGA \tab character \cr
   FG_PCT \tab character \cr
   FG2M \tab character \cr
   FG2A \tab character \cr
   FG2_PCT \tab character \cr
   FG3M \tab character \cr
   FG3A \tab character \cr
   FG3_PCT \tab character \cr
}
}
\description{
\strong{Get NBA Stats API Team Dashboard Player Tracking - Passing}

\strong{Get NBA Stats API Team Dashboard Player Tracking - Passing}
}
\details{
\href{https://www.nba.com/stats/team/1610612749/passes-dash}{Team Player Tracking (Second Spectrum) Stats - Passing}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{ nba_teamdashptpass(team_id = '1610612749', season = year_to_season(most_recent_nba_season() - 1))
}\if{html}{\out{</div>}}
}
\seealso{
Other NBA Team Functions: 
\code{\link{nba_leaguedashteamstats}()},
\code{\link{nba_teamdashboardbyclutch}()},
\code{\link{nba_teamdashboardbygamesplits}()},
\code{\link{nba_teamdashboardbygeneralsplits}()},
\code{\link{nba_teamdashboardbylastngames}()},
\code{\link{nba_teamdashboardbyopponent}()},
\code{\link{nba_teamdashboardbyshootingsplits}()},
\code{\link{nba_teamdashboardbyteamperformance}()},
\code{\link{nba_teamdashboardbyyearoveryear}()},
\code{\link{nba_teamdashlineups}()},
\code{\link{nba_teamdashptreb}()},
\code{\link{nba_teamdashptshots}()},
\code{\link{nba_teamdetails}()},
\code{\link{nba_teamestimatedmetrics}()},
\code{\link{nba_teamgamelogs}()},
\code{\link{nba_teamgamelog}()},
\code{\link{nba_teamgamestreakfinder}()},
\code{\link{nba_teamhistoricalleaders}()},
\code{\link{nba_teaminfocommon}()},
\code{\link{nba_teamplayerdashboard}()},
\code{\link{nba_teamplayeronoffdetails}()},
\code{\link{nba_teamplayeronoffsummary}()},
\code{\link{nba_teams}()},
\code{\link{nba_teamvsplayer}()},
\code{\link{nba_teamyearbyyearstats}()}

Other NBA Player Tracking Functions: 
\code{\link{nba_boxscoreplayertrackv2}()},
\code{\link{nba_leaguedashoppptshot}()},
\code{\link{nba_leaguedashplayerptshot}()},
\code{\link{nba_leaguedashptdefend}()},
\code{\link{nba_leaguedashptstats}()},
\code{\link{nba_leaguedashptteamdefend}()},
\code{\link{nba_leaguedashteamptshot}()},
\code{\link{nba_playerdashptpass}()},
\code{\link{nba_playerdashptreb}()},
\code{\link{nba_playerdashptshotdefend}()},
\code{\link{nba_playerdashptshots}()},
\code{\link{nba_synergyplaytypes}()},
\code{\link{nba_teamdashptreb}()},
\code{\link{nba_teamdashptshots}()}
}
\author{
Saiem Gilani
}
\concept{NBA Player Tracking Functions}
\concept{NBA Team Functions}
