% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nba_stats_player.R
\name{nba_playergamelogs}
\alias{nba_playergamelogs}
\title{\strong{Get NBA Stats API Player Game Logs}}
\usage{
nba_playergamelogs(
  date_from = "",
  date_to = "",
  game_segment = "",
  last_n_games = 0,
  league_id = "00",
  location = "",
  measure_type = "Base",
  month = 0,
  opponent_team_id = 0,
  outcome = "",
  po_round = "",
  per_mode = "Totals",
  period = 0,
  player_id = "2544",
  season = year_to_season(most_recent_nba_season() - 1),
  season_segment = "",
  season_type = "Regular Season",
  team_id = "",
  vs_conference = "",
  vs_division = "",
  ...
)
}
\arguments{
\item{date_from}{date_from}

\item{date_to}{date_to}

\item{game_segment}{game_segment}

\item{last_n_games}{last_n_games}

\item{league_id}{League - default: '00'. Other options include '10': WNBA, '20': G-League}

\item{location}{location}

\item{measure_type}{measure_type}

\item{month}{month}

\item{opponent_team_id}{opponent_team_id}

\item{outcome}{outcome}

\item{po_round}{po_round}

\item{per_mode}{per_mode}

\item{period}{period}

\item{player_id}{Player ID}

\item{season}{Season - format 2020-21}

\item{season_segment}{season_segment}

\item{season_type}{Season Type - Regular Season, Playoffs, All-Star}

\item{team_id}{team_id}

\item{vs_conference}{vs_conference}

\item{vs_division}{vs_division}

\item{...}{Additional arguments passed to an underlying function like httr.}
}
\value{
Return a named list of data frames: PlayerGameLogs

\strong{PlayerGameLogs}\tabular{ll}{
   col_name \tab types \cr
   SEASON_YEAR \tab character \cr
   PLAYER_ID \tab character \cr
   PLAYER_NAME \tab character \cr
   NICKNAME \tab character \cr
   TEAM_ID \tab character \cr
   TEAM_ABBREVIATION \tab character \cr
   TEAM_NAME \tab character \cr
   GAME_ID \tab character \cr
   GAME_DATE \tab character \cr
   MATCHUP \tab character \cr
   WL \tab character \cr
   MIN \tab character \cr
   FGM \tab character \cr
   FGA \tab character \cr
   FG_PCT \tab character \cr
   FG3M \tab character \cr
   FG3A \tab character \cr
   FG3_PCT \tab character \cr
   FTM \tab character \cr
   FTA \tab character \cr
   FT_PCT \tab character \cr
   OREB \tab character \cr
   DREB \tab character \cr
   REB \tab character \cr
   AST \tab character \cr
   TOV \tab character \cr
   STL \tab character \cr
   BLK \tab character \cr
   BLKA \tab character \cr
   PF \tab character \cr
   PFD \tab character \cr
   PTS \tab character \cr
   PLUS_MINUS \tab character \cr
   NBA_FANTASY_PTS \tab character \cr
   DD2 \tab character \cr
   TD3 \tab character \cr
   WNBA_FANTASY_PTS \tab character \cr
   GP_RANK \tab character \cr
   W_RANK \tab character \cr
   L_RANK \tab character \cr
   W_PCT_RANK \tab character \cr
   MIN_RANK \tab character \cr
   FGM_RANK \tab character \cr
   FGA_RANK \tab character \cr
   FG_PCT_RANK \tab character \cr
   FG3M_RANK \tab character \cr
   FG3A_RANK \tab character \cr
   FG3_PCT_RANK \tab character \cr
   FTM_RANK \tab character \cr
   FTA_RANK \tab character \cr
   FT_PCT_RANK \tab character \cr
   OREB_RANK \tab character \cr
   DREB_RANK \tab character \cr
   REB_RANK \tab character \cr
   AST_RANK \tab character \cr
   TOV_RANK \tab character \cr
   STL_RANK \tab character \cr
   BLK_RANK \tab character \cr
   BLKA_RANK \tab character \cr
   PF_RANK \tab character \cr
   PFD_RANK \tab character \cr
   PTS_RANK \tab character \cr
   PLUS_MINUS_RANK \tab character \cr
   NBA_FANTASY_PTS_RANK \tab character \cr
   DD2_RANK \tab character \cr
   TD3_RANK \tab character \cr
   WNBA_FANTASY_PTS_RANK \tab character \cr
   VIDEO_AVAILABLE_FLAG \tab character \cr
}
}
\description{
\strong{Get NBA Stats API Player Game Logs}

\strong{Get NBA Stats API Player Game Logs}
}
\details{
\href{https://www.nba.com/stats/player/2544/boxscores-traditional}{Player Game Logs}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{ nba_playergamelogs(player_id = '2544')
}\if{html}{\out{</div>}}
}
\seealso{
Other NBA Player Functions: 
\code{\link{nba_infographicfanduelplayer}()},
\code{\link{nba_leaguedashplayerbiostats}()},
\code{\link{nba_leaguedashplayerclutch}()},
\code{\link{nba_leaguedashplayershotlocations}()},
\code{\link{nba_leaguedashplayerstats}()},
\code{\link{nba_leagueplayerondetails}()},
\code{\link{nba_leagueseasonmatchups}()},
\code{\link{nba_matchupsrollup}()},
\code{\link{nba_playerawards}()},
\code{\link{nba_playercareerbycollegerollup}()},
\code{\link{nba_playercareerbycollege}()},
\code{\link{nba_playercareerstats}()},
\code{\link{nba_playercompare}()},
\code{\link{nba_playerdashboardbyclutch}()},
\code{\link{nba_playerdashboardbygamesplits}()},
\code{\link{nba_playerdashboardbygeneralsplits}()},
\code{\link{nba_playerdashboardbylastngames}()},
\code{\link{nba_playerdashboardbyopponent}()},
\code{\link{nba_playerdashboardbyshootingsplits}()},
\code{\link{nba_playerdashboardbyteamperformance}()},
\code{\link{nba_playerdashboardbyyearoveryear}()},
\code{\link{nba_playerdashptpass}()},
\code{\link{nba_playerdashptreb}()},
\code{\link{nba_playerdashptshotdefend}()},
\code{\link{nba_playerdashptshots}()},
\code{\link{nba_playerestimatedmetrics}()},
\code{\link{nba_playerfantasyprofilebargraph}()},
\code{\link{nba_playerfantasyprofile}()},
\code{\link{nba_playergamelog}()},
\code{\link{nba_playergamestreakfinder}()},
\code{\link{nba_playerheadshot}()},
\code{\link{nba_playerindex}()},
\code{\link{nba_playernextngames}()},
\code{\link{nba_playerprofilev2}()},
\code{\link{nba_playervsplayer}()}
}
\author{
Saiem Gilani
}
\concept{NBA Player Functions}
