% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/updateHomologene.R
\name{updateHomologene}
\alias{updateHomologene}
\title{Update homologene database}
\usage{
updateHomologene(destfile = NULL,
  baseline = homologene::homologeneData2, gene_history = NULL,
  gene_info = NULL)
}
\arguments{
\item{destfile}{Optional. Path of the output file.}

\item{baseline}{The baseline homologene file to be used. By default uses the
\code{\link{homologeneData2}} that is included in this package. The more ids 
to update, the more time is needed for the update which is why the default option
uses an already updated version of the original database.}

\item{gene_history}{A gene history data frame, possibly returned by \code{\link{getGeneHistory}}
function. Use this if you want to have a static gene_history file to update up to a specific date.
An up to date gene_history object can be set to update to a specific date by trimming
rows that have recent dates. Note that the same is not possible for the gene_info 
If not provided, the latest file will be downloaded.}

\item{gene_info}{A gene info data frame that contatins ID-symbol matches,
possibly returned by \code{\link{getGeneInfo}}. Use this if you
want a static version. Should be in sync with the gene_history file. Note that there is 
no easy way to track changes in gene symbols back in time so if you want to update it up
to a specific date, make sure you don't lose that file.}
}
\value{
Homologene database in a data frame with updated gene IDs and symbols
}
\description{
Creates an updated version of the homologene database. This is done by downloading
the latest gene annotation information and tracing changes in gene symbols and 
identifiers over history. \code{\link{homologeneData2}} was created using 
this function over the original \code{\link{homologeneData}}. This function 
requires downloading large amounts of data from the NCBI ftp servers.
}
