% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geneHistory.R
\name{getGeneInfo}
\alias{getGeneInfo}
\title{Download gene symbol information}
\usage{
getGeneInfo(destfile = NULL, justRead = FALSE, chunk_size = 1e+06)
}
\arguments{
\item{destfile}{Path of the output file. If NULL a temp file will be used}

\item{justRead}{If TRUE and destfile exists, it reads the file instead of 
downloading the latest one from NCBI}

\item{chunk_size}{Chunk size to be used with \code{link[readr]{read_tsv_chunked}}.
The gene_info file is big enough to make its intake difficult. If you don't
have large amounts of free memory you may have to reduce this number to read
the file in smaller chunks}
}
\value{
A data frame with gene symbols for each current gene id
}
\description{
This function downloads the gene_info file from NCBI website and returns the
gene symbols for current IDs.
}
