% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/format.R
\name{tmr_format}
\alias{tmr_format}
\title{Format hms Timer}
\usage{
tmr_format(x, digits = 3, ..., print_title = TRUE)
}
\arguments{
\item{x}{A \code{\link[=hms_timer]{hms_timer()}}.}

\item{digits}{A count of the number of decimal places.}

\item{...}{These dots are for future extensions and must be empty.}

\item{print_title}{A flag specifying whether to print the title.}
}
\value{
A character string.
}
\description{
Converts a \code{\link[=hms_timer]{hms_timer()}} to a string of the clock time
after rounding it to the number of digits.
}
\details{
Negative values of digit are not permitted.
}
\examples{
tmr_format(tmr_timer(61.66))
tmr_format(tmr_timer(61.66), digits = 0)
}
\seealso{
Other round: 
\code{\link{tmr_ceiling}()},
\code{\link{tmr_floor}()},
\code{\link{tmr_round}()}
}
\concept{round}
