% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hmix.R, R/main1.R
\docType{package}
\name{hmix}
\alias{hmix}
\alias{hmix-package}
\title{hmix: an algorithm for time series analysis that leverages hidden Markov models, cluster analysis, and mixture distributions to segment data, detect patterns and predict future sequences.}
\usage{
hmix(
  ts,
  horizon,
  centers = 10,
  n_hidden = 4,
  seed = 42,
  n_tests = 20,
  warmup = 0.5
)
}
\arguments{
\item{ts}{A numeric vector representing the time series data.}

\item{horizon}{Integer. The prediction horizon, specifying how many future points to forecast.}

\item{centers}{Integer. Number of clusters for k-means clustering. Default: 10.}

\item{n_hidden}{Integer. Number of hidden states in the Hidden Markov Model. Default: 4.}

\item{seed}{Integer. Random seed for reproducibility. Default: 42.}

\item{n_tests}{Integer. Number of testing points for back-testing. Default: 20.}

\item{warmup}{Numeric. Proportion of the time series used as the warm-up period before testing. Default: 0.5.}
}
\value{
This function returns a list containing:
\itemize{
  \item model: The HMM model along with its estimated parameters.
\itemize{
     \item hmm_model: The object includes classified observations, initial HMM and trained HMM.
     \item pred_funs: Prediction functions for each point in horizon (rfun, dfun, pfun, qfun)
     }
  \item error_sets: A list of error metrics calculated for each testing point (at this time, CRPS).
}
}
\description{
An algorithm for time series analysis that leverages hidden Markov models, cluster analysis, and mixture distributions to segment data, detect patterns and predict future sequences.

hmix function segments the time series with k-means clustering, fits an HMM to model state transitions, and generates future predictions over a specified horizon. It evaluates model accuracy by calculating the Continuous Ranked Probability Score (CRPS) across multiple test points, producing error metrics that assess the model's predictive performance and robustness.
}
\examples{
\donttest{
# Example usage of hmix function:
result <- hmix(dummy_set$AMZN, horizon = 10, centers = 5, n_hidden = 3, n_tests = 2)
print(result$model)
print(result$error_sets)

# Random sampling for each point in predicted horizon
result$model$pred_funs$t1$rfun(10)

# ICDF for each point in horizon
result$model$pred_funs$t5$qfun(c(0, 1))

# PDF for each point in horizon
result$model$pred_funs$t8$dfun(tail(ts))

# CDF for each point in horizon
result$model$pred_funs$t10$pfun(tail(ts))
}

}
\seealso{
Useful links:
\itemize{
  \item \url{https://rpubs.com/giancarlo_vercellino/hmix}
}

}
\author{
\strong{Maintainer}: Giancarlo Vercellino \email{giancarlo.vercellino@gmail.com} [copyright holder]

}
