% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gcs.R
\name{list_archives}
\alias{list_archives}
\title{List monthly or quarterly archives}
\usage{
list_archives(release = c("monthly", "quarterly"))
}
\arguments{
\item{release}{Series type: \code{"monthly"} or \code{"quarterly"}.}
}
\value{
A \link[tibble:tibble-package]{tibble} of available archives for
download with the following columns:
\itemize{
\item \code{series}: whether \code{"monthly"} or \code{"quarterly"}.
\item \code{dataset}: type of data set (\code{"hgnc_complete_set"},
\code{"symbol-changes-monthly"}, \code{"withdrawn"} or \code{"symbol-changes-quarterly"}).
\item \code{file}: file name.
\item \code{date}: update date.
\item \code{size}: file size.
\item \code{last_modified}: date-time of file last modification on server.
\item \code{md5sum}: MD5 checksum.
\item \code{url}: direct address to the archive.
}
}
\description{
This function lists the monthly and quarterly archives currently available
from the HGNC's Google Cloud Storage.
}
\examples{
try(list_archives())

}
