% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mapping.R
\name{crosswalk}
\alias{crosswalk}
\title{Convert an HGNC value to another}
\usage{
crosswalk(value, from, to = from, hgnc_dataset = import_hgnc_dataset())
}
\arguments{
\item{value}{A character vector of values to be matched in the \code{from} column.
These values must match once and only once in the \code{from} column values,
otherwise \code{NA} is returned.}

\item{from}{The name of the column in the HGNC gene data set (\code{hgnc_dataset})
where values passed in \code{value} are used as queries.}

\item{to}{The name of the column whose values are to be returned,
corresponding to matches in the \code{from} column.}

\item{hgnc_dataset}{A data frame corresponding to a HGNC gene data set.
Typically, you'd get hold of a HGNC gene data set with
\code{\link[=import_hgnc_dataset]{import_hgnc_dataset()}}. For testing purposes and an offline solution,
you may use alternatively the function \code{\link[=hgnc_dataset_example]{hgnc_dataset_example()}}
providing a subset.}
}
\description{
\code{\link[=crosswalk]{crosswalk()}} will convert values found in one of the columns of an
HGNC gene data set to values in another.
}
\examples{
\dontrun{
# Map a gene symbol to its HUGO identifier.
crosswalk(value = "A1BG", from = "symbol", to = "hgnc_id")

# If `from` and `to` refer to the same column, `crosswalk()` will filter
# out unmatched values by converting them to `NA`.
crosswalk(value = c("A1BG", "Not a gene"), from = "symbol", to = "symbol")

# This is the default behavior, so you can simply call:
crosswalk(value = c("A1BG", "Not a gene"), from = "symbol")
}

}
