% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hexify_cell_to_sf.R
\name{hexify_grid_global}
\alias{hexify_grid_global}
\title{Generate a global grid of hexagon polygons}
\usage{
hexify_grid_global(area, aperture = 3L, resround = "nearest")
}
\arguments{
\item{area}{Target cell area in km^2}

\item{aperture}{Grid aperture: 3, 4, or 7}

\item{resround}{Resolution rounding: "nearest", "up", or "down"}
}
\value{
sf object with hexagon polygons covering the globe
}
\description{
Creates hexagon polygons covering the entire Earth.
}
\examples{
library(hexify)
library(sf)

# Coarse global grid (~100,000 km^2 cells)
global_grid <- hexify_grid_global(area = 100000)
plot(st_geometry(global_grid), border = "gray")
}
\seealso{
\code{\link{grid_global}} for the recommended S4 interface,
\code{\link{hexify_grid_rect}} for regional grids

Other sf conversion: 
\code{\link{hex_corners_to_sf}()},
\code{\link{hexify_cell_to_sf}()},
\code{\link{hexify_grid_rect}()}
}
\concept{sf conversion}
\keyword{internal}
