% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hermite_estimator.R
\name{merge_hermite}
\alias{merge_hermite}
\title{Merges a list of Hermite estimators}
\usage{
merge_hermite(hermite_estimators)
}
\arguments{
\item{hermite_estimators}{A list of hermite_estimator_univar or 
hermite_estimator_bivar objects.}
}
\value{
An object of class hermite_estimator_univar or 
hermite_estimator_bivar.
}
\description{
Note that the estimators must be of the same type to be merged i.e. all 
estimators must have a consistent est_type, either "univariate" or 
"bivariate". In addition, the N and standardize arguments must be the same 
for all estimators in order to merge them. Finally, note that exponentially 
weighted estimators cannot be merged. If the Hermite estimators are not 
standardized, the merged estimator will be exactly equivalent to constructing
a single estimator on the data set formed by combining the data sets used to 
update the respective hermite_estimator inputs. If the input Hermite 
estimators are standardized however, then the equivalence will be approximate
but still reasonably accurate in most cases.
}
\examples{
\dontrun{
hermite_est_1 <- hermite_estimator(N = 10, standardize = FALSE, 
observations = rnorm(30))
hermite_est_2 <- hermite_estimator(N = 10, standardize = FALSE, 
observations = rnorm(30))
hermite_merged <- merge_hermite(list(hermite_est_1, hermite_est_2))
}
}
