% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/survival_operations.R
\name{plot.surv_object}
\alias{plot.surv_object}
\title{Plot general survival models}
\usage{
\method{plot}{surv_object}(
  x,
  times = seq.int(0, 30),
  type = c("surv", "prob"),
  psa,
  Nrep = 100,
  join_opts = list(join_col = "red", join_pch = 20, join_size = 3),
  ...
)
}
\arguments{
\item{x}{a survival object of class \code{surv_aft}, \code{surv_add_haz},
\code{surv_ph}, \code{surv_po}, \code{surv_model}, \code{surv_pooled}, or \code{surv_projection}.}

\item{times}{Times at which to evaluate and plot the survival object.}

\item{type}{either \code{surv} (the default) or \code{prob}, depending on whether
you want to plot survival from the start or conditional probabilities.}

\item{psa}{a \code{define_psa} object}

\item{Nrep}{The number of replications to estimate the variability of \code{x}}

\item{join_opts}{A list of 3 graphical parameters for points at which different
survival functions are joined: join_col, join_pch and join_size.}

\item{...}{additional arguments to pass to \code{compute_surv} functions.}
}
\value{
a \code{\link[ggplot2:ggplot]{ggplot2::ggplot()}} object.
}
\description{
Plot general survival models
}
\details{
The function currently only highlights join points that are at
the top level; that is, for objects with class \code{surv_projection}.
To avoid plotting the join points, set join_size to a negative number.
}
\examples{
## Evaluation of the variability of the survival distribution
\donttest{
surv1 <- define_surv_dist("exp", rate = 0.1)
psa <- define_psa(surv1 ~ resample_surv(n = 100))
plot(surv1, psa=psa)

## plot surv_projection object
surv2 <- define_surv_dist("exp", rate = 0.5)
plot(join(surv1, surv2, at = 2), psa = psa, Nrep = 50)

## surv_fit object
library(survival)
km <- define_surv_fit(survfit(formula = Surv(time, status) ~ 1, data = aml))
fs <- flexsurv::flexsurvreg(formula = Surv(time, status) ~ 1, 
                        data = aml, 
                        dist = "weibull") |>
  define_surv_fit()

psa2 <- define_psa(km ~ resample_surv(),
                   fs ~ resample_surv(),
                   surv1 ~ resample_surv(100))
plot(km, psa = psa2)

plot(join(km, surv1, at = 6), psa = psa2)
plot(join(fs, surv1, at = 6), psa = psa2)
}
}
