% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gen.R
\name{gen.structure}
\alias{gen.structure}
\title{Generate a structure}
\usage{
gen.structure(x, ...)
}
\arguments{
\item{x}{an object generator which will have various attributes attached to it.}

\item{...}{attributes, specified in 'tag = value' form, which will be
attached to generated data.}
}
\description{
If you can create an object with \code{structure},
you should be able to generate an object with
this function from a generator or list of
generators.
}
\details{
gen.structure accepts the same forms of data
as forall, and is flexible, in that any list
of generators is considered to be a generator.
}
\examples{
# To create a matrix
gen.structure( gen.c(of = 6, gen.element(1:30)), dim = 3:2)

# To create a data frame for testing.
gen.structure (
  list ( gen.c(of = 4, gen.element(2:10))
       , gen.c(of = 4, gen.element(2:10))
       , c('a', 'b', 'c', 'd')
       )
  , names = c('a','b', 'constant')
  , class = 'data.frame'
  , row.names = c('1', '2', '3', '4' ))
}
