% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_template.R
\name{make_template}
\alias{make_template}
\title{Linearly combine template elements into templates}
\usage{
make_template(data, ...)
}
\arguments{
\item{data}{The dataframe containing variables to be combined.}

\item{...}{The variables to be combined into a template object.}
}
\value{
Returns the collapsed template as a character string.
}
\description{
Applying heddle can leave your template pieces stored as either string
objects, vectors (standalone or in a dataframe), or nested vectors
(if applied using map()). This function takes those elements and combines
them into a single exportable template.
}
\examples{

# When passed vectors, make_template flattens each vector into a single
# string and then combines its arguments from left to right
spList <- data.frame(Species = c(unique(iris$Species), "test string"))
make_template(
  heddle(spList, "SPECIES CODE GWAR ", "GWAR" = Species),
  heddle(spList, "SPECIES CODE GWAR ", "GWAR" = Species)
)

# When passed variables in a dataframe, make_template collapses each column
# in turn, then combines the output strings from left to right
spList <- data.frame(Species = c(unique(iris$Species), "test string"))
spList$template <- heddle(spList, "SPECIES CODE GWAR ", "GWAR" = Species)
make_template(spList, template)
make_template(spList, template, template)

# When passed nested columns, heddlr collapses each cell into a string,
# then collapses each column into a string, and then combines the outputs
# from left to right
make_template(tidyr::nest(spList, nested = template), nested)
}
\seealso{
Other manipulation functions: 
\code{\link{create_yaml_header}()},
\code{\link{heddle}()},
\code{\link{provide_parameters}()},
\code{\link{use_parameters}()}
}
\concept{manipulation functions}
