% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{pnadC_y2024q2}
\alias{pnadC_y2024q2}
\title{PNAD Continua de 2024, 2 trimestre}
\format{
A data frame with 326018 observations on the following variables:
\itemize{
\item{PSU: Primary Sampling Unit identifier (factor)}
\item{weight: Survey weight (numeric)}
\item{age: Age of the respondent (numeric)}
\item{participation: Labor force participation status (factor)}
\item{male: Male indicator (binary)}
\item{white: White indicator (binary)}
\item{hhold_head: Household head indicator (binary)}
\item{hhold_spouse: Spouse of household head indicator (binary)}
\item{yearsSchooling: Total years of schooling completed (numeric)}
\item{classWorker_employer: Employer indicator (binary)}
\item{classWorker_selfEmployed: Self-employed indicator (binary)}
\item{ln_salary: Natural logarithm of salary (numeric)}
}
}
\usage{
pnadC_y2024q2
}
\description{
The Continuous National Household Sample Survey (PNAD Continua)
for the second quarter of 2024 is an important source of
statistical data in Brazil, conducted by the Brazilian Institute
of Geography and Statistics (IBGE). The survey aims to provide
up-to-date information on the socioeconomic characteristics of
the Brazilian population, covering topics such as employment,
income, education, and other crucial aspects for the formulation
of public policies and economic and social studies.
}
\examples{
\donttest{
data(pnadC_y2024q2)
attach(pnadC_y2024q2)
selectEq  <- participation ~ age + I(age^2) +
 male + white + yearsSchooling +
 hhold_head + hhold_spouse
outcomeEq <- ln_salary ~ age + I(age^2) +
 male + white + yearsSchooling +
 classWorker_employer + classWorker_selfEmployed
outcomeD  <- ~ age + I(age^2) +
 male + white + yearsSchooling +
 classWorker_employer + classWorker_selfEmployed
outcomeC  <- ~ male + yearsSchooling
fit_heckmanGE <- heckmanGE(selection   = selectEq,
                           outcome     = outcomeEq,
                           dispersion  = outcomeD,
                           correlation = outcomeC,
                           data = pnadC_y2024q2,
                           weights = weight,
                           cluster = ~PSU)
                           summary(fit_heckmanGE)}
}
\keyword{datasets}
