% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plt-gartner-magic-chart.R
\name{gartner_magic_chart_plt}
\alias{gartner_magic_chart_plt}
\title{Gartner Magic Chart - Plotting of two continuous variables}
\usage{
gartner_magic_chart_plt(
  .data,
  .x_col,
  .y_col,
  .point_size_col = NULL,
  .y_lab = "",
  .x_lab = "",
  .plot_title = "",
  .top_left_label = "",
  .top_right_label = "",
  .bottom_right_label = "",
  .bottom_left_label = ""
)
}
\arguments{
\item{.data}{The dataset you want to plot.}

\item{.x_col}{The x-axis for the plot.}

\item{.y_col}{The y-axis for the plot.}

\item{.point_size_col}{The default is NULL. If you want to size the dots by
a column in the data frame/tibble, enter the column name here.}

\item{.y_lab}{The y-axis label (default: "").}

\item{.x_lab}{The x-axis label (default: "").}

\item{.plot_title}{The title of the plot (default: "").}

\item{.top_left_label}{The top left label (default: "").}

\item{.top_right_label}{The top right label (default: "").}

\item{.bottom_right_label}{The bottom right label (default: "").}

\item{.bottom_left_label}{The bottom left label (default: "").}
}
\value{
A \code{ggplot} plot.
}
\description{
Plot a Gartner Magic Chart of two continuous variables.
}
\examples{
library(dplyr)
library(ggplot2)

data_tbl <- tibble(
  x = rnorm(100, 0, 1),
  y = rnorm(100, 0, 1),
  z = abs(x) + abs(y)
)

gartner_magic_chart_plt(
  .data = data_tbl,
  .x_col = x,
  .y_col = y,
  .point_size_col = z,
  .x_lab = "los",
  .y_lab = "ra",
  .plot_title = "tst",
  .top_right_label = "High RA-LOS",
  .top_left_label = "High RA",
  .bottom_left_label = "Leader",
  .bottom_right_label = "High LOS"
)

gartner_magic_chart_plt(
  .data = data_tbl,
  .x_col = x,
  .y_col = y,
  .point_size_col = NULL,
  .x_lab = "los",
  .y_lab = "ra",
  .plot_title = "tst",
  .top_right_label = "High RA-LOS",
  .top_left_label = "High RA",
  .bottom_left_label = "Leader",
  .bottom_right_label = "High LOS"
)
}
\seealso{
Other Plotting Functions: 
\code{\link{diverging_bar_plt}()},
\code{\link{diverging_lollipop_plt}()},
\code{\link{los_ra_index_plt}()},
\code{\link{ts_alos_plt}()},
\code{\link{ts_median_excess_plt}()},
\code{\link{ts_plt}()},
\code{\link{ts_readmit_rate_plt}()}
}
\author{
Steven P. Sanderson II, MPH
}
\concept{Plotting Functions}
