% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hdcate_main_operators.R
\name{HDCATE.use_cross_fitting}
\alias{HDCATE.use_cross_fitting}
\title{Use k-fold cross-fitting estimator}
\usage{
HDCATE.use_cross_fitting(model, k_fold = 5, folds = NULL)
}
\arguments{
\item{model}{an object created via \link{HDCATE}}

\item{k_fold}{number of folds}

\item{folds}{you can manually set the folds, should be a list of index vector}
}
\value{
None.
}
\description{
Use k-fold cross-fitting estimator
}
\examples{
# get simulation data
n_obs <- 500  # Num of observations
n_var <- 100  # Num of observed variables
n_rel_var <- 4  # Num of relevant variables
data <- HDCATE.get_sim_data(n_obs, n_var, n_rel_var)
# conditional expectation model is misspecified
x_formula <- paste(paste0('X', c(2:n_var)), collapse ='+')
# propensity score model is misspecified
# x_formula <- paste(paste0('X', c(1:(n_var-1))), collapse ='+')

# create a new HDCATE model
model <- HDCATE(data=data, y_name='Y', d_name='D', x_formula=x_formula)

# for example, use 5-fold cross-fitting estimator
HDCATE.use_cross_fitting(model, k_fold=5)

# alternatively, pass a list of index vector to the third argument to set the folds manually,
# in this case, the second argument k_fold is auto detected, you can pass any value to it.
HDCATE.use_cross_fitting(model, k_fold=2, folds=list(c(1:250), c(251:500)))
}
