% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aft_logml_stratified_pp.R
\name{aft.logml.stratified.pp}
\alias{aft.logml.stratified.pp}
\title{Log marginal likelihood of an accelerated failure time (AFT) model under the stratified power prior (PP)}
\usage{
aft.logml.stratified.pp(
  post.samples,
  bridge.args = NULL,
  iter_warmup = 1000,
  iter_sampling = 1000,
  chains = 4,
  ...
)
}
\arguments{
\item{post.samples}{output from \code{\link[=aft.stratified.pp]{aft.stratified.pp()}} giving posterior samples of an AFT model under the stratified
power prior (PP), with an attribute called 'data' which includes the list of variables specified
in the data block of the Stan program.}

\item{bridge.args}{a \code{list} giving arguments (other than \code{samples}, \code{log_posterior}, \code{data}, \code{lb}, and \code{ub}) to
pass onto \code{\link[bridgesampling:bridge_sampler]{bridgesampling::bridge_sampler()}}.}

\item{iter_warmup}{number of warmup iterations to run per chain. Defaults to 1000. See the argument \code{iter_warmup}
in \code{sample()} method in cmdstanr package.}

\item{iter_sampling}{number of post-warmup iterations to run per chain. Defaults to 1000. See the argument \code{iter_sampling}
in \code{sample()} method in cmdstanr package.}

\item{chains}{number of Markov chains to run. Defaults to 4. See the argument \code{chains} in \code{sample()} method
in cmdstanr package.}

\item{...}{arguments passed to \code{sample()} method in cmdstanr package (e.g., \code{seed}, \code{refresh}, \code{init}).}
}
\value{
The function returns a \code{list} with the following objects

\describe{
\item{model}{"aft_stratified_pp"}

\item{logml}{the estimated logarithm of the marginal likelihood}

\item{bs}{an object of class \code{bridge} or \code{bridge_list} containing the output from using \code{\link[bridgesampling:bridge_sampler]{bridgesampling::bridge_sampler()}}
to compute the logarithm of the normalizing constant of the stratified power prior (PP) using all data sets}

\item{bs.hist}{an object of class \code{bridge} or \code{bridge_list} containing the output from using
\code{\link[bridgesampling:bridge_sampler]{bridgesampling::bridge_sampler()}} to compute the logarithm of the normalizing constant of the stratified PP using
historical data sets}

\item{min_ess_bulk}{the minimum estimated bulk effective sample size of the MCMC sampling}

\item{max_Rhat}{the maximum Rhat}
}
}
\description{
Uses Markov chain Monte Carlo (MCMC) and bridge sampling to estimate the logarithm of the marginal
likelihood of an AFT model under the stratified power prior (PP).

The arguments related to MCMC sampling are utilized to draw samples from the stratified power prior (PP).
These samples are then used to compute the logarithm of the normalizing constant of the stratified PP using only
historical data sets.
}
\examples{
if (instantiate::stan_cmdstan_exists()) {
  if(requireNamespace("survival")){
    library(survival)
    data(E1684)
    data(E1690)
    ## take subset for speed purposes
    E1684 = E1684[1:100, ]
    E1690 = E1690[1:50, ]
    ## replace 0 failure times with 0.50 days
    E1684$failtime[E1684$failtime == 0] = 0.50/365.25
    E1690$failtime[E1690$failtime == 0] = 0.50/365.25
    data_list = list(currdata = E1690, histdata = E1684)
    strata_list = list(rep(1:2, each = 25), rep(1:2, each = 50))
    # Alternatively, we can determine the strata based on propensity scores
    # using the psrwe package, which is available on GitHub
    d.stratified.pp = aft.stratified.pp(
      formula = survival::Surv(failtime, failcens) ~ treatment,
      data.list = data_list,
      strata.list = strata_list,
      a0.strata = c(0.3, 0.5),
      dist = "weibull",
      chains = 1, iter_warmup = 500, iter_sampling = 1000
    )
    aft.logml.stratified.pp(
      post.samples = d.stratified.pp,
      bridge.args = list(silent = TRUE),
      chains = 1, iter_warmup = 1000, iter_sampling = 2000
    )
  }
}
}
\references{
Wang, C., Li, H., Chen, W.-C., Lu, N., Tiwari, R., Xu, Y., & Yue, L. Q. (2019). Propensity score-integrated power prior approach for incorporating real-world evidence in single-arm clinical studies. Journal of Biopharmaceutical Statistics, 29(5), 731–748.

Gronau, Q. F., Singmann, H., and Wagenmakers, E.-J. (2020). bridgesampling: An r package for estimating normalizing constants. Journal of Statistical Software, 92(10).
}
